/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Component;
import io.ap4k.component.model.ComponentBuilder;
import io.ap4k.component.model.ComponentFluentImpl;
import io.ap4k.component.model.ComponentList;
import io.ap4k.component.model.ComponentListFluent;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ComponentListFluentImpl<A extends ComponentListFluent<A>>
extends BaseFluent<A>
implements ComponentListFluent<A> {
    private String apiVersion;
    private List<ComponentBuilder> items;
    private String kind;
    private ListMeta metadata;
    private Map<String, Object> additionalProperties;

    public ComponentListFluentImpl() {
    }

    public ComponentListFluentImpl(ComponentList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, Component item) {
        if (this.items == null) {
            this.items = new ArrayList<ComponentBuilder>();
        }
        ComponentBuilder builder = new ComponentBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Component item) {
        if (this.items == null) {
            this.items = new ArrayList<ComponentBuilder>();
        }
        ComponentBuilder builder = new ComponentBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Component ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ComponentBuilder>();
        }
        for (Component item : items) {
            ComponentBuilder builder = new ComponentBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Component> items) {
        if (this.items == null) {
            this.items = new ArrayList<ComponentBuilder>();
        }
        for (Component item : items) {
            ComponentBuilder builder = new ComponentBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Component ... items) {
        for (Component item : items) {
            ComponentBuilder builder = new ComponentBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Component> items) {
        for (Component item : items) {
            ComponentBuilder builder = new ComponentBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Component> getItems() {
        return ComponentListFluentImpl.build(this.items);
    }

    @Override
    public List<Component> buildItems() {
        return ComponentListFluentImpl.build(this.items);
    }

    @Override
    public Component buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Component buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Component buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Component buildMatchingItem(Predicate<ComponentBuilder> predicate) {
        for (ComponentBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<Component> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ComponentBuilder>();
            for (Component item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<ComponentBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(Component ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Component item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ComponentListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ComponentListFluent.ItemsNested<A> addNewItemLike(Component item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ComponentListFluent.ItemsNested<A> setNewItemLike(int index, Component item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ComponentListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ComponentListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ComponentListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ComponentListFluent.ItemsNested<A> editMatchingItem(Predicate<ComponentBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentListFluentImpl that = (ComponentListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ItemsNestedImpl<N>
    extends ComponentFluentImpl<ComponentListFluent.ItemsNested<N>>
    implements ComponentListFluent.ItemsNested<N>,
    Nested<N> {
        private final ComponentBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Component item) {
            this.index = index;
            this.builder = new ComponentBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ComponentBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

