/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.model;

import io.ap4k.component.model.Component;
import io.ap4k.component.model.ComponentFluent;
import io.ap4k.component.model.ComponentFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;

public class ComponentBuilder
extends ComponentFluentImpl<ComponentBuilder>
implements VisitableBuilder<Component, ComponentBuilder> {
    ComponentFluent<?> fluent;
    Boolean validationEnabled;

    public ComponentBuilder() {
        this(true);
    }

    public ComponentBuilder(Boolean validationEnabled) {
        this(new Component(), validationEnabled);
    }

    public ComponentBuilder(ComponentFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ComponentBuilder(ComponentFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Component(), validationEnabled);
    }

    public ComponentBuilder(ComponentFluent<?> fluent, Component instance) {
        this(fluent, instance, true);
    }

    public ComponentBuilder(ComponentFluent<?> fluent, Component instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ComponentBuilder(Component instance) {
        this(instance, (Boolean)true);
    }

    public ComponentBuilder(Component instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public Component build() {
        Component buildable = new Component(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus(), this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentBuilder that = (ComponentBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

