/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.component.config;

import io.ap4k.component.config.CompositeConfig;
import io.ap4k.component.config.CompositeConfigFluent;
import io.ap4k.component.config.Link;
import io.ap4k.component.config.LinkBuilder;
import io.ap4k.component.config.LinkFluentImpl;
import io.ap4k.component.model.DeploymentType;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.KubernetesConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompositeConfigFluentImpl<A extends CompositeConfigFluent<A>>
extends KubernetesConfigFluentImpl<A>
implements CompositeConfigFluent<A> {
    private DeploymentType deploymentType;
    private boolean exposeService;
    private List<LinkBuilder> links = new ArrayList<LinkBuilder>();

    public CompositeConfigFluentImpl() {
    }

    public CompositeConfigFluentImpl(CompositeConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        this.withDeploymentType(instance.getDeploymentType());
        this.withExposeService(instance.isExposeService());
        this.withLinks(instance.getLinks());
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public A withDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
        return (A)this;
    }

    @Override
    public Boolean hasDeploymentType() {
        return this.deploymentType != null;
    }

    @Override
    public boolean isExposeService() {
        return this.exposeService;
    }

    @Override
    public A withExposeService(boolean exposeService) {
        this.exposeService = exposeService;
        return (A)this;
    }

    @Override
    public Boolean hasExposeService() {
        return true;
    }

    @Override
    public A withLinks(Link ... links) {
        if (this.links != null) {
            this.links.clear();
        }
        if (links != null) {
            for (Link item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Link[] getLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link[] buildLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link buildLink(int index) {
        return this.links.get(index).build();
    }

    @Override
    public Link buildFirstLink() {
        return this.links.get(0).build();
    }

    @Override
    public Link buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    @Override
    public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A addToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.links.add(index >= 0 ? index : this.links.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.links.size()) {
            this.links.add(builder);
        } else {
            this.links.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLinks(Link ... items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<Link> items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(Link ... items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<Link> items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> addNewLinkLike(Link item) {
        return new LinksNestedImpl(-1, item);
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> setNewLinkLike(int index, Link item) {
        return new LinksNestedImpl(index, item);
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public CompositeConfigFluent.LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.apply((Object)this.links.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeConfigFluentImpl that = (CompositeConfigFluentImpl)o;
        if (this.deploymentType != null ? !this.deploymentType.equals((Object)that.deploymentType) : that.deploymentType != null) {
            return false;
        }
        if (this.exposeService != that.exposeService) {
            return false;
        }
        return !(this.links != null ? !this.links.equals(that.links) : that.links != null);
    }

    public class LinksNestedImpl<N>
    extends LinkFluentImpl<CompositeConfigFluent.LinksNested<N>>
    implements CompositeConfigFluent.LinksNested<N>,
    Nested<N> {
        private final LinkBuilder builder;
        private final int index;

        LinksNestedImpl(int index, Link item) {
            this.index = index;
            this.builder = new LinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new LinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)CompositeConfigFluentImpl.this.setToLinks(this.index, this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }
}

