/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.application.decorator;

import io.ap4k.deps.applicationcrd.api.model.ApplicationSpecBuilder;
import io.ap4k.deps.applicationcrd.api.model.GroupKind;
import io.ap4k.deps.applicationcrd.api.model.GroupKindBuilder;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.decorator.Decorator;
import java.util.ArrayList;

@Description(value="A decorator that adds GroupKinds to application resources.")
public class GroupKindsDecorator
extends Decorator<KubernetesListBuilder> {
    public void visit(KubernetesListBuilder kubernetesList) {
        final ArrayList<GroupKind> groupKinds = new ArrayList<GroupKind>();
        for (HasMetadata h : kubernetesList.getItems()) {
            groupKinds.add(((GroupKindBuilder)((GroupKindBuilder)new GroupKindBuilder().withKind(h.getKind())).withGroup(GroupKindsDecorator.apiVersionGroup(h.getApiVersion()))).build());
        }
        kubernetesList.accept((Visitor)new Decorator<ApplicationSpecBuilder>(){

            public void visit(ApplicationSpecBuilder applicationSpec) {
                applicationSpec.withComponentKinds(groupKinds);
            }
        });
    }

    private static String apiVersionGroup(String apiVersion) {
        if (apiVersion == null) {
            return null;
        }
        if (apiVersion.contains("/")) {
            return apiVersion.substring(0, apiVersion.indexOf("/"));
        }
        return "core";
    }
}

