/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.application.config;

import io.ap4k.application.config.ApplicationConfig;
import io.ap4k.application.config.ApplicationConfigFluent;
import io.ap4k.application.config.Contact;
import io.ap4k.application.config.ContactBuilder;
import io.ap4k.application.config.ContactFluentImpl;
import io.ap4k.application.config.Icon;
import io.ap4k.application.config.IconBuilder;
import io.ap4k.application.config.IconFluentImpl;
import io.ap4k.application.config.Info;
import io.ap4k.application.config.InfoBuilder;
import io.ap4k.application.config.InfoFluentImpl;
import io.ap4k.application.config.Link;
import io.ap4k.application.config.LinkBuilder;
import io.ap4k.application.config.LinkFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.ConfigurationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationConfigFluentImpl<A extends ApplicationConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements ApplicationConfigFluent<A> {
    private String group = "";
    private String name = "";
    private String version = "";
    private List<ContactBuilder> owners = new ArrayList<ContactBuilder>();
    private List<ContactBuilder> maintainers = new ArrayList<ContactBuilder>();
    private List<InfoBuilder> info = new ArrayList<InfoBuilder>();
    private List<IconBuilder> icons = new ArrayList<IconBuilder>();
    private List<LinkBuilder> links = new ArrayList<LinkBuilder>();
    private String notes = "";
    private List<String> keywords = new ArrayList<String>();

    public ApplicationConfigFluentImpl() {
    }

    public ApplicationConfigFluentImpl(ApplicationConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withOwners(instance.getOwners());
        this.withMaintainers(instance.getMaintainers());
        this.withInfo(instance.getInfo());
        this.withIcons(instance.getIcons());
        this.withLinks(instance.getLinks());
        this.withNotes(instance.getNotes());
        this.withKeywords(instance.getKeywords());
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public A withNewGroup(String arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public A withNewGroup(StringBuilder arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public A withNewGroup(StringBuffer arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A withNewVersion(String arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuilder arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withNewVersion(StringBuffer arg1) {
        return this.withVersion(new String(arg1));
    }

    @Override
    public A withOwners(Contact ... owners) {
        if (this.owners != null) {
            this.owners.clear();
        }
        if (owners != null) {
            for (Contact item : owners) {
                this.addToOwners(item);
            }
        }
        return (A)this;
    }

    @Override
    public Contact[] getOwners() {
        int size = this.owners != null ? this.owners.size() : 0;
        Contact[] result = new Contact[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.owners) {
            result[index++] = (Contact)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Contact[] buildOwners() {
        int size = this.owners != null ? this.owners.size() : 0;
        Contact[] result = new Contact[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.owners) {
            result[index++] = (Contact)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Contact buildOwner(int index) {
        return this.owners.get(index).build();
    }

    @Override
    public Contact buildFirstOwner() {
        return this.owners.get(0).build();
    }

    @Override
    public Contact buildLastOwner() {
        return this.owners.get(this.owners.size() - 1).build();
    }

    @Override
    public Contact buildMatchingOwner(Predicate<ContactBuilder> predicate) {
        for (ContactBuilder item : this.owners) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOwner(Predicate<ContactBuilder> predicate) {
        for (ContactBuilder item : this.owners) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToOwners(int index, Contact item) {
        if (this.owners == null) {
            this.owners = new ArrayList<ContactBuilder>();
        }
        ContactBuilder builder = new ContactBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.owners.add(index >= 0 ? index : this.owners.size(), builder);
        return (A)this;
    }

    @Override
    public A setToOwners(int index, Contact item) {
        if (this.owners == null) {
            this.owners = new ArrayList<ContactBuilder>();
        }
        ContactBuilder builder = new ContactBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.owners.size()) {
            this.owners.add(builder);
        } else {
            this.owners.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOwners(Contact ... items) {
        if (this.owners == null) {
            this.owners = new ArrayList<ContactBuilder>();
        }
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.add(builder);
            this.owners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwners(Collection<Contact> items) {
        if (this.owners == null) {
            this.owners = new ArrayList<ContactBuilder>();
        }
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.add(builder);
            this.owners.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwners(Contact ... items) {
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.remove(builder);
            if (this.owners == null) continue;
            this.owners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwners(Collection<Contact> items) {
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.remove(builder);
            if (this.owners == null) continue;
            this.owners.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwners() {
        return this.owners != null && !this.owners.isEmpty();
    }

    @Override
    public A addNewOwner(String name, String email, String url) {
        return this.addToOwners(new Contact(name, email, url));
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> addNewOwner() {
        return new OwnersNestedImpl();
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> addNewOwnerLike(Contact item) {
        return new OwnersNestedImpl(-1, item);
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> setNewOwnerLike(int index, Contact item) {
        return new OwnersNestedImpl(index, item);
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> editOwner(int index) {
        if (this.owners.size() <= index) {
            throw new RuntimeException("Can't edit owners. Index exceeds size.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> editFirstOwner() {
        if (this.owners.size() == 0) {
            throw new RuntimeException("Can't edit first owners. The list is empty.");
        }
        return this.setNewOwnerLike(0, this.buildOwner(0));
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> editLastOwner() {
        int index = this.owners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last owners. The list is empty.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    @Override
    public ApplicationConfigFluent.OwnersNested<A> editMatchingOwner(Predicate<ContactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.owners.size(); ++i) {
            if (!predicate.apply((Object)this.owners.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching owners. No match found.");
        }
        return this.setNewOwnerLike(index, this.buildOwner(index));
    }

    @Override
    public A withMaintainers(Contact ... maintainers) {
        if (this.maintainers != null) {
            this.maintainers.clear();
        }
        if (maintainers != null) {
            for (Contact item : maintainers) {
                this.addToMaintainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Contact[] getMaintainers() {
        int size = this.maintainers != null ? this.maintainers.size() : 0;
        Contact[] result = new Contact[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.maintainers) {
            result[index++] = (Contact)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Contact[] buildMaintainers() {
        int size = this.maintainers != null ? this.maintainers.size() : 0;
        Contact[] result = new Contact[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.maintainers) {
            result[index++] = (Contact)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Contact buildMaintainer(int index) {
        return this.maintainers.get(index).build();
    }

    @Override
    public Contact buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    @Override
    public Contact buildLastMaintainer() {
        return this.maintainers.get(this.maintainers.size() - 1).build();
    }

    @Override
    public Contact buildMatchingMaintainer(Predicate<ContactBuilder> predicate) {
        for (ContactBuilder item : this.maintainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMaintainer(Predicate<ContactBuilder> predicate) {
        for (ContactBuilder item : this.maintainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToMaintainers(int index, Contact item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList<ContactBuilder>();
        }
        ContactBuilder builder = new ContactBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.maintainers.add(index >= 0 ? index : this.maintainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMaintainers(int index, Contact item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList<ContactBuilder>();
        }
        ContactBuilder builder = new ContactBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.maintainers.size()) {
            this.maintainers.add(builder);
        } else {
            this.maintainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMaintainers(Contact ... items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList<ContactBuilder>();
        }
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMaintainers(Collection<Contact> items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList<ContactBuilder>();
        }
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMaintainers(Contact ... items) {
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.remove(builder);
            if (this.maintainers == null) continue;
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMaintainers(Collection<Contact> items) {
        for (Contact item : items) {
            ContactBuilder builder = new ContactBuilder(item);
            this._visitables.remove(builder);
            if (this.maintainers == null) continue;
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMaintainers() {
        return this.maintainers != null && !this.maintainers.isEmpty();
    }

    @Override
    public A addNewMaintainer(String name, String email, String url) {
        return this.addToMaintainers(new Contact(name, email, url));
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNestedImpl();
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> addNewMaintainerLike(Contact item) {
        return new MaintainersNestedImpl(-1, item);
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> setNewMaintainerLike(int index, Contact item) {
        return new MaintainersNestedImpl(index, item);
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> editMaintainer(int index) {
        if (this.maintainers.size() <= index) {
            throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> editFirstMaintainer() {
        if (this.maintainers.size() == 0) {
            throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(0, this.buildMaintainer(0));
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> editLastMaintainer() {
        int index = this.maintainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public ApplicationConfigFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<ContactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.maintainers.size(); ++i) {
            if (!predicate.apply((Object)this.maintainers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching maintainers. No match found.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public A withInfo(Info ... info) {
        if (this.info != null) {
            this.info.clear();
        }
        if (info != null) {
            for (Info item : info) {
                this.addToInfo(item);
            }
        }
        return (A)this;
    }

    @Override
    public Info[] getInfo() {
        int size = this.info != null ? this.info.size() : 0;
        Info[] result = new Info[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.info) {
            result[index++] = (Info)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Info[] buildInfo() {
        int size = this.info != null ? this.info.size() : 0;
        Info[] result = new Info[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.info) {
            result[index++] = (Info)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Info buildInfo(int index) {
        return this.info.get(index).build();
    }

    @Override
    public Info buildFirstInfo() {
        return this.info.get(0).build();
    }

    @Override
    public Info buildLastInfo() {
        return this.info.get(this.info.size() - 1).build();
    }

    @Override
    public Info buildMatchingInfo(Predicate<InfoBuilder> predicate) {
        for (InfoBuilder item : this.info) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInfo(Predicate<InfoBuilder> predicate) {
        for (InfoBuilder item : this.info) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToInfo(int index, Info item) {
        if (this.info == null) {
            this.info = new ArrayList<InfoBuilder>();
        }
        InfoBuilder builder = new InfoBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.info.add(index >= 0 ? index : this.info.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInfo(int index, Info item) {
        if (this.info == null) {
            this.info = new ArrayList<InfoBuilder>();
        }
        InfoBuilder builder = new InfoBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.info.size()) {
            this.info.add(builder);
        } else {
            this.info.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInfo(Info ... items) {
        if (this.info == null) {
            this.info = new ArrayList<InfoBuilder>();
        }
        for (Info item : items) {
            InfoBuilder builder = new InfoBuilder(item);
            this._visitables.add(builder);
            this.info.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInfo(Collection<Info> items) {
        if (this.info == null) {
            this.info = new ArrayList<InfoBuilder>();
        }
        for (Info item : items) {
            InfoBuilder builder = new InfoBuilder(item);
            this._visitables.add(builder);
            this.info.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInfo(Info ... items) {
        for (Info item : items) {
            InfoBuilder builder = new InfoBuilder(item);
            this._visitables.remove(builder);
            if (this.info == null) continue;
            this.info.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInfo(Collection<Info> items) {
        for (Info item : items) {
            InfoBuilder builder = new InfoBuilder(item);
            this._visitables.remove(builder);
            if (this.info == null) continue;
            this.info.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInfo() {
        return this.info != null && !this.info.isEmpty();
    }

    @Override
    public A addNewInfo(String name, String value, String type, String valueFrom) {
        return this.addToInfo(new Info(name, value, type, valueFrom));
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> addNewInfo() {
        return new InfoNestedImpl();
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> addNewInfoLike(Info item) {
        return new InfoNestedImpl(-1, item);
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> setNewInfoLike(int index, Info item) {
        return new InfoNestedImpl(index, item);
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> editInfo(int index) {
        if (this.info.size() <= index) {
            throw new RuntimeException("Can't edit info. Index exceeds size.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> editFirstInfo() {
        if (this.info.size() == 0) {
            throw new RuntimeException("Can't edit first info. The list is empty.");
        }
        return this.setNewInfoLike(0, this.buildInfo(0));
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> editLastInfo() {
        int index = this.info.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last info. The list is empty.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    @Override
    public ApplicationConfigFluent.InfoNested<A> editMatchingInfo(Predicate<InfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.info.size(); ++i) {
            if (!predicate.apply((Object)this.info.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching info. No match found.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    @Override
    public A withIcons(Icon ... icons) {
        if (this.icons != null) {
            this.icons.clear();
        }
        if (icons != null) {
            for (Icon item : icons) {
                this.addToIcons(item);
            }
        }
        return (A)this;
    }

    @Override
    public Icon[] getIcons() {
        int size = this.icons != null ? this.icons.size() : 0;
        Icon[] result = new Icon[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.icons) {
            result[index++] = (Icon)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Icon[] buildIcons() {
        int size = this.icons != null ? this.icons.size() : 0;
        Icon[] result = new Icon[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.icons) {
            result[index++] = (Icon)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Icon buildIcon(int index) {
        return this.icons.get(index).build();
    }

    @Override
    public Icon buildFirstIcon() {
        return this.icons.get(0).build();
    }

    @Override
    public Icon buildLastIcon() {
        return this.icons.get(this.icons.size() - 1).build();
    }

    @Override
    public Icon buildMatchingIcon(Predicate<IconBuilder> predicate) {
        for (IconBuilder item : this.icons) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIcon(Predicate<IconBuilder> predicate) {
        for (IconBuilder item : this.icons) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToIcons(int index, Icon item) {
        if (this.icons == null) {
            this.icons = new ArrayList<IconBuilder>();
        }
        IconBuilder builder = new IconBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.icons.add(index >= 0 ? index : this.icons.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIcons(int index, Icon item) {
        if (this.icons == null) {
            this.icons = new ArrayList<IconBuilder>();
        }
        IconBuilder builder = new IconBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.icons.size()) {
            this.icons.add(builder);
        } else {
            this.icons.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIcons(Icon ... items) {
        if (this.icons == null) {
            this.icons = new ArrayList<IconBuilder>();
        }
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.add(builder);
            this.icons.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIcons(Collection<Icon> items) {
        if (this.icons == null) {
            this.icons = new ArrayList<IconBuilder>();
        }
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.add(builder);
            this.icons.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIcons(Icon ... items) {
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.remove(builder);
            if (this.icons == null) continue;
            this.icons.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIcons(Collection<Icon> items) {
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.remove(builder);
            if (this.icons == null) continue;
            this.icons.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIcons() {
        return this.icons != null && !this.icons.isEmpty();
    }

    @Override
    public A addNewIcon(String type, String src, String size) {
        return this.addToIcons(new Icon(type, src, size));
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> addNewIcon() {
        return new IconsNestedImpl();
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> addNewIconLike(Icon item) {
        return new IconsNestedImpl(-1, item);
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> setNewIconLike(int index, Icon item) {
        return new IconsNestedImpl(index, item);
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> editIcon(int index) {
        if (this.icons.size() <= index) {
            throw new RuntimeException("Can't edit icons. Index exceeds size.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> editFirstIcon() {
        if (this.icons.size() == 0) {
            throw new RuntimeException("Can't edit first icons. The list is empty.");
        }
        return this.setNewIconLike(0, this.buildIcon(0));
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> editLastIcon() {
        int index = this.icons.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last icons. The list is empty.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    @Override
    public ApplicationConfigFluent.IconsNested<A> editMatchingIcon(Predicate<IconBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.icons.size(); ++i) {
            if (!predicate.apply((Object)this.icons.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching icons. No match found.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    @Override
    public A withLinks(Link ... links) {
        if (this.links != null) {
            this.links.clear();
        }
        if (links != null) {
            for (Link item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Link[] getLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link[] buildLinks() {
        int size = this.links != null ? this.links.size() : 0;
        Link[] result = new Link[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.links) {
            result[index++] = (Link)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Link buildLink(int index) {
        return this.links.get(index).build();
    }

    @Override
    public Link buildFirstLink() {
        return this.links.get(0).build();
    }

    @Override
    public Link buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    @Override
    public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLink(Predicate<LinkBuilder> predicate) {
        for (LinkBuilder item : this.links) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.links.add(index >= 0 ? index : this.links.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLinks(int index, Link item) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        LinkBuilder builder = new LinkBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.links.size()) {
            this.links.add(builder);
        } else {
            this.links.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLinks(Link ... items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<Link> items) {
        if (this.links == null) {
            this.links = new ArrayList<LinkBuilder>();
        }
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(Link ... items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<Link> items) {
        for (Link item : items) {
            LinkBuilder builder = new LinkBuilder(item);
            this._visitables.remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    @Override
    public A addNewLink(String description, String url) {
        return this.addToLinks(new Link(description, url));
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> addNewLinkLike(Link item) {
        return new LinksNestedImpl(-1, item);
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> setNewLinkLike(int index, Link item) {
        return new LinksNestedImpl(index, item);
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public ApplicationConfigFluent.LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.apply((Object)this.links.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public A withNotes(String notes) {
        this.notes = notes;
        return (A)this;
    }

    @Override
    public Boolean hasNotes() {
        return this.notes != null;
    }

    @Override
    public A withNewNotes(String arg1) {
        return this.withNotes(new String(arg1));
    }

    @Override
    public A withNewNotes(StringBuilder arg1) {
        return this.withNotes(new String(arg1));
    }

    @Override
    public A withNewNotes(StringBuffer arg1) {
        return this.withNotes(new String(arg1));
    }

    @Override
    public A withKeywords(String ... keywords) {
        if (this.keywords != null) {
            this.keywords.clear();
        }
        if (keywords != null) {
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getKeywords() {
        int size = this.keywords != null ? this.keywords.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.keywords) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(index, item);
        return (A)this;
    }

    @Override
    public A setToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.set(index, item);
        return (A)this;
    }

    @Override
    public A addToKeywords(String ... items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromKeywords(String ... items) {
        for (String item : items) {
            if (this.keywords == null) continue;
            this.keywords.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKeywords(Collection<String> items) {
        for (String item : items) {
            if (this.keywords == null) continue;
            this.keywords.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    @Override
    public A addNewKeyword(String arg1) {
        return this.addToKeywords(new String(arg1));
    }

    @Override
    public A addNewKeyword(StringBuilder arg1) {
        return this.addToKeywords(new String(arg1));
    }

    @Override
    public A addNewKeyword(StringBuffer arg1) {
        return this.addToKeywords(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationConfigFluentImpl that = (ApplicationConfigFluentImpl)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.owners != null ? !this.owners.equals(that.owners) : that.owners != null) {
            return false;
        }
        if (this.maintainers != null ? !this.maintainers.equals(that.maintainers) : that.maintainers != null) {
            return false;
        }
        if (this.info != null ? !this.info.equals(that.info) : that.info != null) {
            return false;
        }
        if (this.icons != null ? !this.icons.equals(that.icons) : that.icons != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        return !(this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null);
    }

    public class LinksNestedImpl<N>
    extends LinkFluentImpl<ApplicationConfigFluent.LinksNested<N>>
    implements ApplicationConfigFluent.LinksNested<N>,
    Nested<N> {
        private final LinkBuilder builder;
        private final int index;

        LinksNestedImpl(int index, Link item) {
            this.index = index;
            this.builder = new LinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new LinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationConfigFluentImpl.this.setToLinks(this.index, this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }

    public class IconsNestedImpl<N>
    extends IconFluentImpl<ApplicationConfigFluent.IconsNested<N>>
    implements ApplicationConfigFluent.IconsNested<N>,
    Nested<N> {
        private final IconBuilder builder;
        private final int index;

        IconsNestedImpl(int index, Icon item) {
            this.index = index;
            this.builder = new IconBuilder(this, item);
        }

        IconsNestedImpl() {
            this.index = -1;
            this.builder = new IconBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationConfigFluentImpl.this.setToIcons(this.index, this.builder.build());
        }

        @Override
        public N endIcon() {
            return this.and();
        }
    }

    public class InfoNestedImpl<N>
    extends InfoFluentImpl<ApplicationConfigFluent.InfoNested<N>>
    implements ApplicationConfigFluent.InfoNested<N>,
    Nested<N> {
        private final InfoBuilder builder;
        private final int index;

        InfoNestedImpl(int index, Info item) {
            this.index = index;
            this.builder = new InfoBuilder(this, item);
        }

        InfoNestedImpl() {
            this.index = -1;
            this.builder = new InfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationConfigFluentImpl.this.setToInfo(this.index, this.builder.build());
        }

        @Override
        public N endInfo() {
            return this.and();
        }
    }

    public class MaintainersNestedImpl<N>
    extends ContactFluentImpl<ApplicationConfigFluent.MaintainersNested<N>>
    implements ApplicationConfigFluent.MaintainersNested<N>,
    Nested<N> {
        private final ContactBuilder builder;
        private final int index;

        MaintainersNestedImpl(int index, Contact item) {
            this.index = index;
            this.builder = new ContactBuilder(this, item);
        }

        MaintainersNestedImpl() {
            this.index = -1;
            this.builder = new ContactBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationConfigFluentImpl.this.setToMaintainers(this.index, this.builder.build());
        }

        @Override
        public N endMaintainer() {
            return this.and();
        }
    }

    public class OwnersNestedImpl<N>
    extends ContactFluentImpl<ApplicationConfigFluent.OwnersNested<N>>
    implements ApplicationConfigFluent.OwnersNested<N>,
    Nested<N> {
        private final ContactBuilder builder;
        private final int index;

        OwnersNestedImpl(int index, Contact item) {
            this.index = index;
            this.builder = new ContactBuilder(this, item);
        }

        OwnersNestedImpl() {
            this.index = -1;
            this.builder = new ContactBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationConfigFluentImpl.this.setToOwners(this.index, this.builder.build());
        }

        @Override
        public N endOwner() {
            return this.and();
        }
    }
}

