/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.application.handler;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.application.config.ApplicationConfig;
import io.ap4k.application.config.Contact;
import io.ap4k.application.config.EditableApplicationConfig;
import io.ap4k.application.config.Icon;
import io.ap4k.application.decorator.GroupKindsDecorator;
import io.ap4k.deps.applicationcrd.api.model.ApplicationBuilder;
import io.ap4k.deps.applicationcrd.api.model.ApplicationFluent;
import io.ap4k.deps.applicationcrd.api.model.ApplicationSpecFluent;
import io.ap4k.deps.applicationcrd.api.model.ContactData;
import io.ap4k.deps.applicationcrd.api.model.ContactDataBuilder;
import io.ap4k.deps.applicationcrd.api.model.ImageSpec;
import io.ap4k.deps.applicationcrd.api.model.ImageSpecBuilder;
import io.ap4k.deps.applicationcrd.api.model.Link;
import io.ap4k.deps.applicationcrd.api.model.LinkBuilder;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.decorator.Decorator;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ApplicationHandler
implements Handler<ApplicationConfig> {
    private final Resources resources;

    public ApplicationHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 10000;
    }

    public void handle(ApplicationConfig config) {
        this.resources.add((HasMetadata)((ApplicationBuilder)((ApplicationFluent.SpecNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationSpecFluent.DescriptorNested)((ApplicationFluent.SpecNested)((ApplicationSpecFluent.SelectorNested)((ApplicationBuilder)((ApplicationFluent.MetadataNested)((ApplicationFluent.MetadataNested)new ApplicationBuilder().withNewMetadata().withName(this.resources.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(this.resources.getLabels())).endSelector()).withNewDescriptor().withVersion(this.resources.getVersion())).withOwners(Arrays.stream(config.getOwners()).map(ApplicationHandler::adapt).collect(Collectors.toList()))).withMaintainers(Arrays.stream(config.getMaintainers()).map(ApplicationHandler::adapt).collect(Collectors.toList()))).withIcons(Arrays.stream(config.getIcons()).map(ApplicationHandler::adapt).collect(Collectors.toList()))).withLinks(Arrays.stream(config.getLinks()).map(ApplicationHandler::adapt).collect(Collectors.toList()))).withKeywords(config.getKeywords())).withNotes(config.getNotes())).endDescriptor()).endSpec()).build());
        this.resources.decorate((Decorator)new GroupKindsDecorator());
    }

    public boolean canHandle(Class<? extends Configuration> config) {
        return ApplicationConfig.class.equals(config) || EditableApplicationConfig.class.equals(config);
    }

    private static ContactData adapt(Contact contact) {
        return ((ContactDataBuilder)((ContactDataBuilder)((ContactDataBuilder)new ContactDataBuilder().withName(contact.getName())).withEmail(contact.getEmail())).withUrl(contact.getUrl())).build();
    }

    private static Link adapt(io.ap4k.application.config.Link link) {
        return ((LinkBuilder)((LinkBuilder)new LinkBuilder().withUrl(link.getUrl())).withDescription(link.getDescription())).build();
    }

    private static ImageSpec adapt(Icon icon) {
        return ((ImageSpecBuilder)((ImageSpecBuilder)((ImageSpecBuilder)new ImageSpecBuilder().withSize(icon.getSize())).withSrc(icon.getSrc())).withType(icon.getType())).build();
    }
}

