/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl.content;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.common.data.content.Image;
import io.annot8.implementations.support.content.AbstractContentBuilder;
import io.annot8.implementations.support.content.AbstractContentBuilderFactory;
import io.annot8.testing.testimpl.AbstractTestContent;
import io.annot8.testing.testimpl.TestAnnotationStore;
import io.annot8.testing.testimpl.TestProperties;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import javax.imageio.ImageIO;

public class TestImage
extends AbstractTestContent<BufferedImage>
implements Image {
    private int height;
    private Integer width;

    public TestImage() {
        this(null);
    }

    public TestImage(Item item) {
        this(item, "id", "description", new TestProperties(), () -> new BufferedImage(100, 100, 1));
    }

    public TestImage(Item item, String id, String description, ImmutableProperties properties, Supplier<BufferedImage> data) {
        super(item, BufferedImage.class, TestAnnotationStore::new, id, description, properties, data);
        this.height = data.get().getHeight();
        this.width = data.get().getWidth();
    }

    public Class<Image> getContentClass() {
        return Image.class;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void saveAsJpg(OutputStream outputStream) throws IOException {
        BufferedImage bImgRgb = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = bImgRgb.createGraphics();
        g.drawImage((java.awt.Image)this.getData(), 0, 0, null);
        g.dispose();
        boolean ret = ImageIO.write((RenderedImage)bImgRgb, "jpg", outputStream);
        if (!ret) {
            throw new IOException("No writer found for format JPG");
        }
    }

    public void saveAsPng(OutputStream outputStream) throws IOException {
        boolean ret = ImageIO.write((RenderedImage)this.getData(), "png", outputStream);
        if (!ret) {
            throw new IOException("No writer found for format PNG");
        }
    }

    public static class BuilderFactory
    extends AbstractContentBuilderFactory<BufferedImage, Image> {
        public BuilderFactory() {
            super(BufferedImage.class, Image.class);
        }

        public Content.Builder<Image, BufferedImage> create(Item item) {
            return new Builder(item);
        }
    }

    public static class Builder
    extends AbstractContentBuilder<BufferedImage, Image> {
        protected Builder(Item item) {
            super(item);
        }

        protected Image create(String id, String description, ImmutableProperties properties, Supplier<BufferedImage> data) {
            return new TestImage(this.getItem(), id, description, properties, data);
        }
    }
}

