/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.data.Content;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.implementations.support.delegates.DelegateAnnotationBuilder;
import io.annot8.implementations.support.factories.AnnotationBuilderFactory;
import io.annot8.testing.testimpl.TestAnnotationBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class TestAnnotationStore
implements AnnotationStore {
    private final Map<String, Annotation> annotations = new ConcurrentHashMap<String, Annotation>();
    private final AnnotationBuilderFactory annotationBuilderFactory;
    private Content<?> content;

    public TestAnnotationStore(Content<?> content) {
        this(content, TestAnnotationBuilder.factory());
    }

    public TestAnnotationStore(Content<?> content, AnnotationBuilderFactory annotationBuilderFactory) {
        this.content = content;
        this.annotationBuilderFactory = annotationBuilderFactory;
    }

    public Content<?> getContent() {
        return this.content;
    }

    public void setContent(Content<?> content) {
        this.content = content;
    }

    public Annotation.Builder getBuilder() {
        return new DelegateAnnotationBuilder(this.annotationBuilderFactory.create(this.content, (AnnotationStore)this)){

            public Annotation save() {
                return TestAnnotationStore.this.save(super.save());
            }
        };
    }

    public Annotation save(Annotation.Builder annotationBuilder) {
        Annotation annotation = (Annotation)annotationBuilder.save();
        return this.save(annotation);
    }

    public Annotation save(Annotation annotation) {
        this.annotations.put(annotation.getId(), annotation);
        return annotation;
    }

    public void delete(Annotation annotation) {
        this.annotations.remove(annotation.getId());
    }

    public Stream<Annotation> getAll() {
        return this.annotations.values().stream();
    }

    public Optional<Annotation> getById(String annotationId) {
        return Optional.ofNullable(this.annotations.get(annotationId));
    }
}

