/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.testing.testimpl.TestBounds;
import io.annot8.testing.testimpl.TestProperties;
import java.util.Objects;
import java.util.UUID;

public class TestAnnotation
implements Annotation {
    private Bounds bounds;
    private String content;
    private String id;
    private ImmutableProperties properties;
    private String type;

    public TestAnnotation() {
        this(UUID.randomUUID().toString(), "testContentDescription");
    }

    public TestAnnotation(String id, String content) {
        this(id, content, "testAnnotationType");
    }

    public TestAnnotation(String id, String content, String type) {
        this(id, content, type, new TestBounds());
    }

    public TestAnnotation(String id, String content, String type, Bounds bounds) {
        this.id = id;
        this.content = content;
        this.type = type;
        this.bounds = bounds;
        this.properties = new TestProperties();
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public String getContentId() {
        return this.content;
    }

    public void setContentId(String content) {
        this.content = content;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ImmutableProperties properties) {
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestAnnotation that = (TestAnnotation)o;
        return Objects.equals(this.bounds, that.bounds) && Objects.equals(this.content, that.content) && Objects.equals(this.id, that.id) && Objects.equals(this.properties, that.properties) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.bounds, this.content, this.id, this.properties, this.type);
    }

    public String toString() {
        return String.format("TestAnnotation[%s]", this.getId());
    }
}

