/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl.content;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.data.content.UriContent;
import io.annot8.implementations.support.content.AbstractContentBuilder;
import io.annot8.implementations.support.content.AbstractContentBuilderFactory;
import io.annot8.testing.testimpl.TestAnnotationStore;
import java.net.URI;
import java.util.function.Supplier;

public class TestUriContent
implements UriContent {
    private final URI data;
    private Item item;
    private String id;
    private final String description;
    private final ImmutableProperties properties;
    private final AnnotationStore store;

    public TestUriContent(Item item, String id, String description, ImmutableProperties properties, URI data) {
        this.item = item;
        this.id = id;
        this.description = description;
        this.properties = properties;
        this.store = new TestAnnotationStore((Content<?>)this);
        this.data = data;
    }

    public Item getItem() {
        return this.item;
    }

    public URI getData() {
        return this.data;
    }

    public Class<URI> getDataClass() {
        return URI.class;
    }

    public Class<? extends Content<URI>> getContentClass() {
        return UriContent.class;
    }

    public AnnotationStore getAnnotations() {
        return this.store;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public static class TestURLBuilderFactory
    extends AbstractContentBuilderFactory<URI, UriContent> {
        public TestURLBuilderFactory() {
            super(URI.class, UriContent.class);
        }

        public Content.Builder<UriContent, URI> create(Item item) {
            return new TestUriBuilder(item);
        }
    }

    public static class TestUriBuilder
    extends AbstractContentBuilder<URI, UriContent> {
        public TestUriBuilder(Item item) {
            super(item);
        }

        protected UriContent create(String id, String description, ImmutableProperties properties, Supplier<URI> data) {
            return new TestUriContent(this.getItem(), id, description, properties, data.get());
        }
    }
}

