/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.implementations.support.stores.AnnotationStoreFactory;
import io.annot8.testing.testimpl.TestAnnotationStore;
import io.annot8.testing.testimpl.TestProperties;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractTestContent<D>
implements Content<D> {
    private Item item;
    private String id;
    private final Class<D> dataClass;
    private String description;
    private ImmutableProperties properties;
    private AnnotationStore annotations;
    private Supplier<D> data;

    public AbstractTestContent(Item item, Class<D> dataClass) {
        this(item, dataClass, "testContentDescription");
    }

    public AbstractTestContent(Item item, Class<D> dataClass, String description) {
        this(item, dataClass, UUID.randomUUID().toString(), description, new TestProperties());
    }

    public AbstractTestContent(Item item, Class<D> dataClass, String id, String description, ImmutableProperties properties) {
        this(item, (Class<Object>)dataClass, id, description, properties, null);
    }

    public AbstractTestContent(Item item, Class<D> dataClass, String id, String description, ImmutableProperties properties, Supplier<D> data) {
        this(item, dataClass, TestAnnotationStore::new, id, description, properties, data);
    }

    public AbstractTestContent(Item item, Class<D> dataClass, AnnotationStoreFactory annotationStoreFactory, String id, String description, ImmutableProperties properties, Supplier<D> data) {
        this.item = item;
        this.id = id;
        this.dataClass = dataClass;
        this.description = description;
        this.properties = properties;
        this.data = data;
        this.annotations = annotationStoreFactory.create((Content)this);
    }

    public AbstractTestContent(Item item, Class<D> dataClass, String id, String description, ImmutableProperties properties, D data) {
        this(item, (Class<Supplier<Object>>)dataClass, id, description, properties, () -> data);
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Class<D> getDataClass() {
        return this.dataClass;
    }

    public D getData() {
        return this.data.get();
    }

    public void setData(D data) {
        if (data == null) {
            this.setData((Supplier)null);
        } else {
            this.setData(() -> data);
        }
    }

    public void setData(Supplier<D> data) {
        this.data = data;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ImmutableProperties properties) {
        this.properties = properties;
    }
}

