/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.InputStreamContent;
import io.annot8.common.data.content.TableContent;
import io.annot8.common.data.content.Text;
import io.annot8.common.data.content.UriContent;
import io.annot8.common.implementations.factories.ContentBuilderFactory;
import io.annot8.common.implementations.registries.SimpleContentBuilderFactoryRegistry;
import io.annot8.core.data.BaseItem;
import io.annot8.core.data.Content;
import io.annot8.core.properties.Properties;
import io.annot8.testing.testimpl.AbstractTestContent;
import io.annot8.testing.testimpl.TestProperties;
import io.annot8.testing.testimpl.content.TestFileContent;
import io.annot8.testing.testimpl.content.TestInputStreamContent;
import io.annot8.testing.testimpl.content.TestStringContent;
import io.annot8.testing.testimpl.content.TestTableContent;
import io.annot8.testing.testimpl.content.TestUriContent;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContentBuilderFactoryRegistry
extends SimpleContentBuilderFactoryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestContentBuilderFactoryRegistry.class);

    public TestContentBuilderFactoryRegistry() {
        this(true);
    }

    public TestContentBuilderFactoryRegistry(boolean includeDefaultContentBuilders) {
        if (includeDefaultContentBuilders) {
            this.register(Text.class, (ContentBuilderFactory)new TestStringContent.BuilderFactory());
            this.register(FileContent.class, (ContentBuilderFactory)new TestFileContent.BuilderFactory());
            this.register(InputStreamContent.class, (ContentBuilderFactory)new TestInputStreamContent.BuilderFactory());
            this.register(UriContent.class, (ContentBuilderFactory)new TestUriContent.TestURLBuilderFactory());
            this.register(TableContent.class, (ContentBuilderFactory)new TestTableContent.BuilderFactory());
        }
    }

    public <D, C extends Content<D>> Optional<ContentBuilderFactory<D, C>> get(Class<C> contentClass) {
        if (AbstractTestContent.class.isAssignableFrom(contentClass)) {
            try {
                return Optional.of(new TestContentBuilderFactory(contentClass));
            }
            catch (Exception e) {
                LOGGER.error("Unable to create test content", (Throwable)e);
            }
        }
        return super.get(contentClass);
    }

    public static class TestContentBuilder<D, C extends AbstractTestContent<D>>
    implements Content.Builder<C, D> {
        private final C instance;
        private final TestProperties builderProperties = new TestProperties();

        public TestContentBuilder(C instance) {
            this.instance = instance;
        }

        public Content.Builder<C, D> withId(String id) {
            ((AbstractTestContent)this.instance).setId(id);
            return this;
        }

        public Content.Builder<C, D> withName(String name) {
            ((AbstractTestContent)this.instance).setName(name);
            return this;
        }

        public Content.Builder<C, D> withData(Supplier<D> data) {
            ((AbstractTestContent)this.instance).setData(data);
            return this;
        }

        public Content.Builder<C, D> from(C from) {
            this.withProperties((Properties)((AbstractTestContent)from).getProperties());
            return this;
        }

        public Content.Builder<C, D> withProperty(String key, Object value) {
            this.builderProperties.set(key, value);
            return this;
        }

        public Content.Builder<C, D> withoutProperty(String key, Object value) {
            Optional opt = this.builderProperties.get(key);
            if (opt.isPresent() && opt.get().equals(value)) {
                this.builderProperties.remove(key);
            }
            return this;
        }

        public Content.Builder<C, D> withoutProperty(String key) {
            this.builderProperties.remove(key);
            return this;
        }

        public Content.Builder<C, D> withProperties(Properties properties) {
            this.builderProperties.add(properties.getAll());
            return this;
        }

        public C save() {
            ((AbstractTestContent)this.instance).setProperties(this.builderProperties);
            return this.instance;
        }
    }

    public static class TestContentBuilderFactory<D, C extends AbstractTestContent<D>>
    implements ContentBuilderFactory<D, C> {
        private final C instance;
        private final Class<C> contentClass;

        public TestContentBuilderFactory(Class<C> contentClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
            this.contentClass = contentClass;
            this.instance = (AbstractTestContent)contentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }

        public Content.Builder<C, D> create(BaseItem item) {
            return new TestContentBuilder(this.instance);
        }

        public Class getDataClass() {
            return ((AbstractTestContent)this.instance).getDataClass();
        }

        public Class<C> getContentClass() {
            return this.contentClass;
        }
    }
}

