/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.implementations.factories.AnnotationBuilderFactory;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.properties.MutableProperties;
import io.annot8.core.properties.Properties;
import io.annot8.testing.testimpl.TestAnnotation;
import io.annot8.testing.testimpl.TestProperties;
import java.util.Optional;
import java.util.UUID;

public class TestAnnotationBuilder
implements Annotation.Builder {
    private final MutableProperties properties = new TestProperties();
    private String contentId;
    private Bounds bounds;
    private String id;
    private String type;

    public TestAnnotationBuilder(String contentId) {
        this.contentId = contentId;
    }

    public static AnnotationBuilderFactory factory() {
        return (content, store) -> new TestAnnotationBuilder(content);
    }

    public Annotation.Builder withId(String id) {
        this.id = id;
        return this;
    }

    public Annotation.Builder withBounds(Bounds bounds) {
        this.bounds = bounds;
        return this;
    }

    public Annotation save() {
        String assignedId = this.id == null ? UUID.randomUUID().toString() : this.id;
        TestAnnotation annotation = new TestAnnotation();
        annotation.setBounds(this.bounds);
        annotation.setContentId(this.contentId);
        annotation.setId(assignedId);
        annotation.setType(this.type);
        TestProperties testProperties = new TestProperties();
        testProperties.add(this.properties.getAll());
        annotation.setProperties(testProperties);
        return annotation;
    }

    public Annotation.Builder from(Annotation from) {
        this.contentId = from.getContentId();
        this.bounds = from.getBounds();
        this.id = from.getId();
        this.type = from.getType();
        this.properties.add(from.getProperties().getAll());
        return this;
    }

    public Annotation.Builder newId() {
        this.id = null;
        return this;
    }

    public Annotation.Builder withProperty(String key, Object value) {
        this.properties.set(key, value);
        return this;
    }

    public Annotation.Builder withoutProperty(String key, Object value) {
        Optional opt = this.properties.get(key);
        if (opt.isPresent() && opt.get().equals(value)) {
            this.properties.remove(key);
        }
        return this;
    }

    public Annotation.Builder withoutProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    public Annotation.Builder withProperties(Properties properties) {
        this.properties.add(properties.getAll());
        return this;
    }

    public Annotation.Builder withType(String type) {
        this.type = type;
        return this;
    }
}

