/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.implementations.stores.AnnotationStoreFactory;
import io.annot8.core.data.Content;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.stores.AnnotationStore;
import io.annot8.testing.testimpl.TestAnnotationStore;
import io.annot8.testing.testimpl.TestProperties;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractTestContent<D>
implements Content<D> {
    private String id;
    private final Class<D> dataClass;
    private String name;
    private ImmutableProperties properties;
    private AnnotationStore annotations;
    private Supplier<D> data;

    public AbstractTestContent(Class<D> dataClass) {
        this(dataClass, "testContentName");
    }

    public AbstractTestContent(Class<D> dataClass, String name) {
        this(dataClass, UUID.randomUUID().toString(), name, new TestProperties());
    }

    public AbstractTestContent(Class<D> dataClass, String id, String name, ImmutableProperties properties) {
        this((Class<Object>)dataClass, id, name, properties, null);
    }

    public AbstractTestContent(Class<D> dataClass, String id, String name, ImmutableProperties properties, Supplier<D> data) {
        this(dataClass, n -> new TestAnnotationStore(n.getId()), id, name, properties, data);
    }

    public AbstractTestContent(Class<D> dataClass, AnnotationStoreFactory annotationStoreFactory, String id, String name, ImmutableProperties properties, Supplier<D> data) {
        this.id = id;
        this.dataClass = dataClass;
        this.name = name;
        this.properties = properties;
        this.data = data;
        this.annotations = annotationStoreFactory.create((Content)this);
    }

    public AbstractTestContent(Class<D> dataClass, String id, String name, ImmutableProperties properties, D data) {
        this((Class<Supplier<Object>>)dataClass, id, name, properties, () -> data);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Class<D> getDataClass() {
        return this.dataClass;
    }

    public D getData() {
        return this.data.get();
    }

    public void setData(D data) {
        if (data == null) {
            this.setData((Supplier)null);
        } else {
            this.setData(() -> data);
        }
    }

    public void setData(Supplier<D> data) {
        this.data = data;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ImmutableProperties properties) {
        this.properties = properties;
    }
}

