/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.implementations.factories.ContentBuilderFactory;
import io.annot8.common.implementations.registries.ContentBuilderFactoryRegistry;
import io.annot8.common.utils.java.StreamUtils;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.data.ItemFactory;
import io.annot8.core.exceptions.AlreadyExistsException;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.exceptions.UnsupportedContentException;
import io.annot8.core.properties.MutableProperties;
import io.annot8.core.stores.GroupStore;
import io.annot8.testing.testimpl.TestContentBuilderFactoryRegistry;
import io.annot8.testing.testimpl.TestGroupStore;
import io.annot8.testing.testimpl.TestProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class TestItem
implements Item {
    private final String parentId;
    private final String id;
    private final ItemFactory itemFactory;
    private MutableProperties properties;
    private GroupStore groups;
    private ContentBuilderFactoryRegistry contentBuilderFactoryRegistry;
    private Map<String, Content<?>> content = new ConcurrentHashMap();
    private boolean discarded = false;

    public TestItem() {
        this(null, new TestGroupStore());
    }

    public TestItem(ItemFactory itemFactory) {
        this(itemFactory, new TestGroupStore());
    }

    public TestItem(ItemFactory itemFactory, String parentId) {
        this(itemFactory, (GroupStore)new TestGroupStore(), parentId);
    }

    public TestItem(ItemFactory itemFactory, GroupStore groupStore) {
        this(itemFactory, groupStore, (ContentBuilderFactoryRegistry)new TestContentBuilderFactoryRegistry());
    }

    public TestItem(ItemFactory itemFactory, GroupStore groupStore, String parentId) {
        this(itemFactory, groupStore, (ContentBuilderFactoryRegistry)new TestContentBuilderFactoryRegistry(), parentId);
    }

    public TestItem(ItemFactory itemFactory, GroupStore groupStore, ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this(itemFactory, groupStore, contentBuilderFactoryRegistry, null);
    }

    public TestItem(ItemFactory itemFactory, GroupStore groupStore, ContentBuilderFactoryRegistry contentBuilderFactoryRegistry, String parentId) {
        this.id = UUID.randomUUID().toString();
        this.parentId = parentId;
        this.itemFactory = itemFactory;
        this.properties = new TestProperties();
        this.groups = groupStore;
        this.contentBuilderFactoryRegistry = contentBuilderFactoryRegistry;
    }

    public Stream<String> listNames() {
        return this.content.values().stream().map(Content::getName);
    }

    public Optional<Content<?>> getContent(String id) {
        return Optional.ofNullable(this.content.get(id));
    }

    public Stream<Content<?>> getContents() {
        return this.content.values().stream();
    }

    public <T extends Content<?>> Stream<T> getContents(Class<T> clazz) {
        return StreamUtils.cast(this.getContents(), clazz);
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getParent() {
        return Optional.of(this.parentId);
    }

    public <C extends Content<D>, D> Content.Builder<C, D> create(Class<C> clazz) throws UnsupportedContentException {
        Optional optional = this.contentBuilderFactoryRegistry.get(clazz);
        if (!optional.isPresent()) {
            throw new UnsupportedContentException("No content builder factory " + clazz.getSimpleName());
        }
        ContentBuilderFactory factory = (ContentBuilderFactory)optional.get();
        return factory.create((Item)this, this::save);
    }

    public <C extends Content<D>, D> C save(Content.Builder<C, D> builder) throws AlreadyExistsException {
        Content c;
        try {
            c = (Content)builder.save();
        }
        catch (IncompleteException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        if (this.content.get(c.getName()) != null) {
            throw new AlreadyExistsException("Already exists " + c.getName());
        }
        return (C)this.save(c);
    }

    public <D, C extends Content<D>> C save(C c) {
        this.content.put(c.getId(), c);
        return c;
    }

    public void removeContent(String id) {
        this.content.remove(id);
    }

    public GroupStore getGroups() {
        return this.groups;
    }

    public void setGroups(GroupStore groups) {
        this.groups = groups;
    }

    public MutableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MutableProperties properties) {
        this.properties = properties;
    }

    public ContentBuilderFactoryRegistry getContentBuilderFactoryRegistry() {
        return this.contentBuilderFactoryRegistry;
    }

    public void setContentBuilderFactoryRegistry(ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this.contentBuilderFactoryRegistry = contentBuilderFactoryRegistry;
    }

    public Map<String, Content<?>> getContent() {
        return this.content;
    }

    public void setContent(Map<String, Content<?>> content) {
        this.content = content;
    }

    public Item createChildItem() {
        if (this.itemFactory == null) {
            throw new UnsupportedOperationException();
        }
        return this.itemFactory.create((Item)this);
    }

    public void discard() {
        this.discarded = true;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }
}

