/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.implementations.factories.GroupBuilderFactory;
import io.annot8.core.annotations.Group;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.stores.GroupStore;
import io.annot8.testing.testimpl.TestGroupBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class TestGroupStore
implements GroupStore {
    private final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();
    private final GroupBuilderFactory<Group> groupBuilderFactory;
    private Item item;

    public TestGroupStore() {
        this(null);
    }

    public TestGroupStore(Item item, GroupBuilderFactory<Group> groupBuilderFactory) {
        this.item = item;
        this.groupBuilderFactory = groupBuilderFactory;
    }

    public TestGroupStore(Item item) {
        this(item, TestGroupBuilder.factory());
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    public Group.Builder getBuilder() {
        return this.groupBuilderFactory.create(this.item, (GroupStore)this, this::save);
    }

    public Group save(Group.Builder groupBuilder) throws IncompleteException {
        Group group = (Group)groupBuilder.save();
        return this.save(group);
    }

    public Group save(Group group) {
        this.groups.put(group.getId(), group);
        return group;
    }

    public void delete(Group group) {
        this.groups.remove(group.getId());
    }

    public Stream<Group> getAll() {
        return this.groups.values().stream();
    }

    public Optional<Group> getById(String groupId) {
        return Optional.ofNullable(this.groups.get(groupId));
    }
}

