/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.core.annotations.Annotation;
import io.annot8.core.annotations.Group;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.references.AnnotationReference;
import io.annot8.testing.testimpl.TestAnnotationReference;
import io.annot8.testing.testimpl.TestProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class TestGroup
implements Group {
    private String id;
    private ImmutableProperties properties;
    private String type;
    private Map<AnnotationReference, String> annotations = new HashMap<AnnotationReference, String>();

    public TestGroup() {
        this(UUID.randomUUID().toString(), "testGroupType");
    }

    public TestGroup(String id, String type) {
        this.id = id;
        this.type = type;
        this.properties = new TestProperties();
    }

    public Map<String, Stream<AnnotationReference>> getReferences() {
        HashMap<String, Stream<AnnotationReference>> ret = new HashMap<String, Stream<AnnotationReference>>();
        this.annotations.forEach((key, value) -> {
            Stream s = ret.getOrDefault(value, Stream.empty());
            ret.put((String)value, Stream.concat(s, Stream.of(key)));
        });
        return ret;
    }

    public void setAnnotations(Map<AnnotationReference, String> annotations) {
        this.annotations = annotations;
    }

    public Optional<String> getRole(Annotation annotation) {
        String role = this.annotations.get(new TestAnnotationReference(annotation));
        return Optional.ofNullable(role);
    }

    public boolean containsAnnotation(Annotation annotation) {
        return this.annotations.containsKey(new TestAnnotationReference(annotation));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ImmutableProperties properties) {
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestGroup testGroup = (TestGroup)o;
        return Objects.equals(this.id, testGroup.id) && Objects.equals(this.properties, testGroup.properties) && Objects.equals(this.type, testGroup.type) && Objects.equals(this.annotations, testGroup.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.properties, this.type, this.annotations);
    }
}

