/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.content;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.api.stores.AnnotationStore;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractContent<D>
implements Content<D> {
    private final Class<D> dataClass;
    private final Class<? extends Content<D>> contentClass;
    private final String id;
    private final String description;
    private final AnnotationStore annotations;
    private final ImmutableProperties properties;
    private final Supplier<D> data;
    private final Item item;

    protected AbstractContent(Item item, Class<D> dataClass, Class<? extends Content<D>> contentClass, Function<Content<?>, AnnotationStore> annotations, String id, String description, ImmutableProperties properties, Supplier<D> data) {
        this.item = item;
        this.dataClass = dataClass;
        this.contentClass = contentClass;
        this.id = id;
        this.description = description;
        this.properties = properties;
        this.data = data;
        this.annotations = annotations.apply(this);
    }

    public Item getItem() {
        return this.item;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public D getData() {
        return this.data.get();
    }

    public Class<D> getDataClass() {
        return this.dataClass;
    }

    public Class<? extends Content<D>> getContentClass() {
        return this.contentClass;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }
}

