/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.tck.impl;

import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.helpers.WithProperties;
import io.annot8.core.helpers.builders.WithPropertiesBuilder;
import io.annot8.core.helpers.builders.WithSave;
import io.annot8.core.properties.Properties;
import io.annot8.testing.testimpl.TestProperties;
import org.junit.jupiter.api.Assertions;

public class WithPropertiesBuilderTestUtils<T extends WithPropertiesBuilder<T> & WithSave<WithProperties>> {
    public void testWithPropertiesBuilder(T propertiesBuilderTestable) {
        this.testWithProperty(propertiesBuilderTestable);
        this.testWithProperties(propertiesBuilderTestable);
        this.testWithoutProperty(propertiesBuilderTestable);
        this.testWithoutKeyValue(propertiesBuilderTestable);
    }

    private void testWithProperty(T propertiesBuilderTestable) {
        WithProperties properties = null;
        try {
            properties = (WithProperties)((WithSave)((WithPropertiesBuilder)propertiesBuilderTestable.withProperty("testPropertyKey", (Object)"testPropertyValue"))).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Test should not fail here");
        }
        Assertions.assertTrue((boolean)properties.getProperties().has("testPropertyKey"));
        Assertions.assertEquals((Object)"testPropertyValue", properties.getProperties().get("testPropertyKey").get());
    }

    private void testWithProperties(T propertiesBuilderTestable) {
        TestProperties toAdd = new TestProperties();
        toAdd.set("testPropertyKey", (Object)"testPropertyValue");
        WithProperties properties = null;
        try {
            properties = (WithProperties)((WithSave)((WithPropertiesBuilder)propertiesBuilderTestable.withProperties((Properties)toAdd))).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Test should not fail here");
        }
        Assertions.assertTrue((boolean)properties.getProperties().has("testPropertyKey"));
        Assertions.assertEquals((Object)"testPropertyValue", properties.getProperties().get("testPropertyKey").get());
    }

    private void testWithoutProperty(T propertiesBuilderTestable) {
        WithProperties properties = null;
        try {
            properties = (WithProperties)((WithSave)((WithPropertiesBuilder)((WithPropertiesBuilder)propertiesBuilderTestable.withProperty("testPropertyKey", (Object)"testPropertyValue")).withoutProperty("testPropertyKey"))).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Test should not fail here");
        }
        Assertions.assertFalse((boolean)properties.getProperties().has("testPropertyKey"));
    }

    private void testWithoutKeyValue(T propertiesBuilderTestable) {
        TestProperties toAdd = new TestProperties();
        toAdd.set("testPropertyKey", (Object)"testPropertyValue");
        WithProperties properties = null;
        try {
            properties = (WithProperties)((WithSave)((WithPropertiesBuilder)((WithPropertiesBuilder)propertiesBuilderTestable.withProperty("testPropertyKey", (Object)"testPropertyValue")).withoutProperty("testPropertyKey", (Object)"testPropertyValue"))).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Test should not fail here");
        }
        Assertions.assertFalse((boolean)properties.getProperties().has("testPropertyKey"));
    }
}

