/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.tck.impl;

import io.annot8.common.data.content.Text;
import io.annot8.core.data.BaseItem;
import io.annot8.core.data.Content;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.exceptions.UnsupportedContentException;
import io.annot8.core.helpers.WithName;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractItemTest {
    protected abstract BaseItem getItem();

    @Test
    public void testGetContent() {
        BaseItem item = this.getItem();
        try {
            ((Content.Builder)item.create(Text.class).withData(() -> "test").withName("testContentName").withId("testContentId")).save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not fail here", (Throwable)e);
        }
        Optional optional = item.getContent("testContentId");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optional.isPresent());
        Content content = (Content)optional.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testContentId", (Object)content.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testContentName", (Object)content.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)content.getData());
    }

    @Test
    public void testGetContents() {
        BaseItem item = this.getItem();
        try {
            item.create(Text.class).withData(() -> "test").withName("testContentName").save();
            item.create(Text.class).withData(() -> "test2").withName("content2").save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not error here", (Throwable)e);
        }
        Assertions.assertThat(item.getContents().map(Content::getData).map(String.class::cast)).containsExactlyInAnyOrder((Object[])new String[]{"test", "test2"});
        Assertions.assertThat(item.getContents().map(WithName::getName)).containsExactlyInAnyOrder((Object[])new String[]{"testContentName", "content2"});
    }

    @Test
    public void testCreate() {
        BaseItem item = this.getItem();
        Text test = null;
        try {
            test = (Text)item.create(Text.class).withName("testContentName").withData((Object)"test").save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not throw an exception.", (Throwable)e);
        }
        org.junit.jupiter.api.Assertions.assertNotNull(test);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testContentName", (Object)test.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)test.getData());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)test.getId());
    }

    @Test
    public void testRemoveContent() {
        BaseItem item = this.getItem();
        try {
            ((Content.Builder)item.create(Text.class).withData(() -> "test").withName("testContentName").withId("testContentId")).save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not fail here", (Throwable)e);
        }
        Assertions.assertThat((Stream)item.getContents()).isNotEmpty();
        item.removeContent("testContentId");
        Assertions.assertThat((Stream)item.getContents()).isEmpty();
    }

    @Test
    public void testDiscard() {
        BaseItem item = this.getItem();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)item.isDiscarded());
        item.discard();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)item.isDiscarded());
    }
}

