/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.tck.impl;

import io.annot8.common.implementations.properties.MapMutableProperties;
import io.annot8.common.implementations.stores.AnnotationStoreFactory;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.annotations.Group;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.properties.Properties;
import io.annot8.core.stores.AnnotationStore;
import io.annot8.core.stores.GroupStore;
import io.annot8.testing.testimpl.TestAnnotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractGroupStoreTest {
    private static final String role = "test";
    private static final String key = "key";
    private static final String value = "value";
    private static final String TEST_ANNOTATION_ID = "TEST_ANNOTATION_ID";
    private static final String TEST_CONTENT_NAME = "TEST_CONTENT_NAME";

    protected abstract GroupStore getGroupStore(Item var1);

    @Test
    public void testGetBuilder() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        this.testGroupBuilder(groupStore.getBuilder());
    }

    @Test
    public void testCreate() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        this.testGroupBuilder(groupStore.create());
    }

    @Test
    public void testCopy() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Annotation annotation = this.getTestAnnotation();
        Group group = this.createTestGroup(groupStore, annotation);
        Group copied = null;
        try {
            copied = (Group)groupStore.copy(group).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Failed to copy group.", (Throwable)e);
        }
        Assertions.assertNotEquals((Object)group.getId(), (Object)copied.getId());
        Assertions.assertEquals((Object)role, (Object)copied.getType());
        Assertions.assertTrue((boolean)copied.getProperties().has(key));
        Assertions.assertEquals((Object)value, copied.getProperties().get(key).get());
    }

    @Test
    public void testEdit() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Annotation annotation = this.getTestAnnotation();
        Group group = this.createTestGroup(groupStore, annotation);
        Group edit = null;
        try {
            edit = (Group)groupStore.edit(group).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Failed to copy group.", (Throwable)e);
        }
        Assertions.assertEquals((Object)group.getId(), (Object)edit.getId());
        Assertions.assertEquals((Object)role, (Object)edit.getType());
        Assertions.assertTrue((boolean)edit.getProperties().has(key));
        Assertions.assertEquals((Object)value, edit.getProperties().get(key).get());
    }

    @Test
    public void testDelete() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Group group = this.createTestGroup(groupStore, this.getTestAnnotation());
        Assertions.assertEquals((long)1L, (long)groupStore.getAll().count());
        groupStore.delete(group);
        Assertions.assertEquals((long)0L, (long)groupStore.getAll().count());
    }

    @Test
    public void testDeleteAll() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Group group = this.createTestGroup(groupStore, this.getTestAnnotation());
        Assertions.assertEquals((long)1L, (long)groupStore.getAll().count());
        groupStore.deleteAll();
        Assertions.assertEquals((long)0L, (long)groupStore.getAll().count());
    }

    @Test
    public void testGetAll() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Group group = this.createTestGroup(groupStore, this.getTestAnnotation());
        Assertions.assertEquals((long)1L, (long)groupStore.getAll().count());
        Assertions.assertEquals((Object)group.getId(), (Object)((Group)groupStore.getAll().findFirst().get()).getId());
    }

    @Test
    public void testGetByType() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Group group = this.createTestGroup(groupStore, this.getTestAnnotation());
        ((Group.Builder)groupStore.create().withType("wrongType")).withAnnotation("testing", this.getTestAnnotation());
        List byType = groupStore.getByType(role).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)byType.size());
        Group group2 = (Group)byType.get(0);
        Assertions.assertEquals((Object)group.getId(), (Object)group2.getId());
        Assertions.assertEquals((Object)role, (Object)group2.getType());
    }

    @Test
    public void testGetById() {
        GroupStore groupStore = this.getGroupStore(this.getTestItem());
        Group group = this.createTestGroup(groupStore, this.getTestAnnotation());
        Optional byId = groupStore.getById(group.getId());
        Assertions.assertTrue((boolean)byId.isPresent());
        Group retrieved = (Group)byId.get();
        Assertions.assertEquals((Object)group.getId(), (Object)retrieved.getId());
        Assertions.assertEquals((Object)group.getType(), (Object)retrieved.getType());
    }

    private Group createTestGroup(GroupStore store, Annotation annotation) {
        Group group = null;
        try {
            group = (Group)((Group.Builder)((Group.Builder)store.create().withAnnotation(role, annotation).withProperty(key, (Object)value)).withType(role)).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Failed to build group.", (Throwable)e);
        }
        return group;
    }

    private void testGroupBuilder(Group.Builder groupBuilder) {
        String groupType = "groupType";
        String propKey1 = "key1";
        String propKey2 = "key2";
        String propKey3 = "key3";
        String propVal1 = "val1";
        String propVal2 = "val2";
        String propVal3 = "val3";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(propKey1, propVal1);
        properties.put(propKey2, propVal2);
        Annotation annotation = this.getTestAnnotation();
        Group group = null;
        try {
            group = (Group)((Group.Builder)((Group.Builder)((Group.Builder)((Group.Builder)((Group.Builder)groupBuilder.withType(groupType)).withProperties((Properties)new MapMutableProperties(properties))).withProperty(propKey3, (Object)propVal3)).withoutProperty(propKey1)).withoutProperty(propKey2, (Object)propVal2)).withAnnotation(role, annotation).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Group failed to build", (Throwable)e);
        }
        Assertions.assertEquals((Object)groupType, (Object)group.getType());
        Assertions.assertNotNull((Object)group.getId());
        Assertions.assertEquals((Object)propVal3, group.getProperties().get(propKey3).get());
        Assertions.assertFalse((boolean)group.getProperties().has(propVal1));
        Assertions.assertFalse((boolean)group.getProperties().has(propVal2));
        Map groupAnnotationsMap = group.getAnnotations();
        Assertions.assertTrue((boolean)groupAnnotationsMap.containsKey(role));
        List annotationsList = ((Stream)groupAnnotationsMap.get(role)).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)annotationsList.size());
        Assertions.assertEquals((Object)annotation.getId(), (Object)((Annotation)annotationsList.get(0)).getId());
    }

    private Item getTestItem() {
        Item mock = (Item)Mockito.mock(Item.class);
        Content mockContent = (Content)Mockito.mock(Content.class);
        Mockito.when((Object)mockContent.getId()).thenReturn((Object)"TEST_CONTENT_ID");
        Mockito.when((Object)mockContent.getName()).thenReturn((Object)TEST_CONTENT_NAME);
        Mockito.when((Object)mock.getId()).thenReturn((Object)"TEST_ITEM_ID");
        Mockito.when((Object)mock.getContent((String)ArgumentMatchers.eq((Object)TEST_CONTENT_NAME))).thenReturn(Optional.of(mockContent));
        return mock;
    }

    private Annotation getTestAnnotation() {
        TestAnnotation annotation = new TestAnnotation();
        annotation.setContentId(TEST_CONTENT_NAME);
        annotation.setId(TEST_ANNOTATION_ID);
        return annotation;
    }

    protected AnnotationStoreFactory getMockedAnnotationStoreFactory() {
        AnnotationStoreFactory mock = (AnnotationStoreFactory)Mockito.mock(AnnotationStoreFactory.class);
        AnnotationStore mockedStore = (AnnotationStore)Mockito.mock(AnnotationStore.class);
        Mockito.when((Object)mockedStore.getById(TEST_ANNOTATION_ID)).thenReturn(Optional.of(this.getTestAnnotation()));
        Mockito.when((Object)mock.create((Content)ArgumentMatchers.any())).thenReturn((Object)mockedStore);
        return mock;
    }
}

