/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.tck.impl;

import io.annot8.common.implementations.properties.MapImmutableProperties;
import io.annot8.common.implementations.properties.MapMutableProperties;
import io.annot8.common.implementations.stores.ContentStore;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.testing.testimpl.TestItem;
import io.annot8.testing.testimpl.content.TestStringContent;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractContentStoreTest {
    private static final String TEST_ID = "TEST_ID";
    private static final String TEST_NAME = "TEST_NAME";
    private static final String TEST_DATA = "TEST_DATA";
    private static final String TEST_PROPERTY_KEY = "TEST_PROPERTY_KEY";
    private static final String TEST_PROPERTY_VALUE = "TEST_PROPERTY_VALUE";
    private final TestItem item = new TestItem();

    protected abstract ContentStore getContentStore(Item var1);

    @Test
    public void testGetContent() {
        TestStringContent testContent = this.createDefaultTestContent();
        ContentStore contentStore = this.getContentStore((Item)this.item);
        contentStore.save((Content)testContent);
        List content = contentStore.getContent().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)content.size());
        this.testDefaultContent((Content)content.get(0));
        contentStore.save((Content)this.createTestContent("TEST_CONTENT_2", this.createTestProperties(), TEST_DATA, "TEST_NAME_2"));
        Assertions.assertEquals((long)2L, (long)contentStore.getContent().count());
    }

    @Test
    public void testGetContentWithName() {
        ContentStore contentStore = this.getContentStore((Item)this.item);
        contentStore.save((Content)this.createDefaultTestContent());
        String contentName2 = "TEST_NAME_2";
        String testId2 = "TEST_CONTENT_2";
        contentStore.save((Content)this.createTestContent(testId2, this.createTestProperties(), TEST_DATA, contentName2));
        Optional content = contentStore.getContent(TEST_NAME);
        Assertions.assertTrue((boolean)content.isPresent());
        this.testDefaultContent((Content)content.get());
        Optional content2 = contentStore.getContent(contentName2);
        Assertions.assertTrue((boolean)content.isPresent());
        this.testContentFields(testId2, contentName2, TEST_DATA, TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE, (Content)content2.get());
    }

    @Test
    public void testGetContentNames() {
        ContentStore contentStore = this.getContentStore((Item)this.item);
        contentStore.save((Content)this.createDefaultTestContent());
        String contentName2 = "contentName2";
        String contentId2 = "contentId2";
        contentStore.save((Content)this.createTestContent(contentId2, this.createTestProperties(), TEST_DATA, contentName2));
        List contentNames = contentStore.getContentNames().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)contentNames.size());
        Assertions.assertTrue((boolean)contentNames.contains(TEST_NAME));
        Assertions.assertTrue((boolean)contentNames.contains(contentName2));
    }

    @Test
    public void testRemoveContent() {
        ContentStore contentStore = this.getContentStore((Item)this.item);
        contentStore.save((Content)this.createDefaultTestContent());
        Assertions.assertEquals((long)1L, (long)contentStore.getContent().count());
        contentStore.removeContent(TEST_ID);
        Assertions.assertEquals((long)1L, (long)contentStore.getContent().count());
    }

    @Test
    public void testSave() {
        ContentStore contentStore = this.getContentStore((Item)this.item);
        Content savedContent = contentStore.save((Content)this.createDefaultTestContent());
        this.testDefaultContent(savedContent);
    }

    private void testContentFields(String expectedId, String expectedName, String expectedData, String expectedPropertyKey, String expectedPropertyValue, Content content) {
        Assertions.assertEquals((Object)expectedId, (Object)content.getId());
        Assertions.assertEquals((Object)expectedName, (Object)content.getName());
        Assertions.assertEquals((Object)expectedData, (Object)content.getData());
        Assertions.assertTrue((boolean)content.getProperties().has(expectedPropertyKey));
        Assertions.assertEquals((Object)expectedPropertyValue, content.getProperties().get(expectedPropertyKey).get());
    }

    private void testDefaultContent(Content content) {
        this.testContentFields(TEST_ID, TEST_NAME, TEST_DATA, TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE, content);
    }

    private ImmutableProperties createTestProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE);
        MapMutableProperties simpleMutableProperties = new MapMutableProperties(props);
        MapImmutableProperties.Builder propsBuilder = new MapImmutableProperties.Builder();
        ImmutableProperties properties = null;
        try {
            properties = (ImmutableProperties)((ImmutableProperties.Builder)propsBuilder.from((Object)simpleMutableProperties)).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Failed to build properties", (Throwable)e);
        }
        return properties;
    }

    private TestStringContent createTestContent(String id, ImmutableProperties properties, String data, String name) {
        return new TestStringContent(id, name, properties, () -> data);
    }

    private TestStringContent createDefaultTestContent() {
        return new TestStringContent(TEST_ID, TEST_NAME, this.createTestProperties(), () -> TEST_DATA);
    }
}

