/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.tck.impl;

import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.data.Content;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.helpers.WithId;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.stores.AnnotationStore;
import io.annot8.testing.testimpl.TestBounds;
import io.annot8.testing.testimpl.TestProperties;
import io.annot8.testing.testimpl.content.TestStringContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractAnnotationStoreTest {
    private static final String TEST_ID = "TEST_ID";
    private static final String TEST_DATA = "TEST_DATA";
    private static final String TEST_NAME = "TEST_NAME";
    private static final String TEST_ANNOTATION_ID = "TEST_ANNOTATION";
    private static final String TEST_ANNOTATION_TYPE = "TEST_TYPE";
    private static final String TEST_PROPERTY_KEY = "TEST_KEY";
    private static final String TEST_PROPERTY_VALUE = "TEST_VALUE";
    private final TestBounds bounds = new TestBounds();

    protected abstract AnnotationStore getAnnotationStore(Content var1);

    private Content getTestContent() {
        return new TestStringContent(TEST_ID, TEST_NAME, (ImmutableProperties)new TestProperties(), () -> TEST_DATA);
    }

    @Test
    public void testGetBuilder() {
        this.testBuilder(this.getAnnotationStore(this.getTestContent()).getBuilder());
        this.testIncompleteBuilder(this.getAnnotationStore(this.getTestContent()).getBuilder());
    }

    @Test
    public void testCreate() {
        this.testBuilder(this.getAnnotationStore(this.getTestContent()).create());
        this.testIncompleteBuilder(this.getAnnotationStore(this.getTestContent()).create());
    }

    @Test
    public void testCreateSameId() {
        String updated = "updated";
        this.createDefaultTestAnnotation();
        this.createTestAnnotation(TEST_ANNOTATION_ID, updated, TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE);
        List all = this.getAnnotationStore(this.getTestContent()).getAll().collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)all.size());
        Assertions.assertEquals((Object)"updated", (Object)((Annotation)all.get(0)).getType());
    }

    @Test
    public void testCopy() {
        Annotation annotation = this.createDefaultTestAnnotation();
        Annotation copied = null;
        try {
            copied = (Annotation)this.getAnnotationStore(this.getTestContent()).copy(annotation).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Exception not expected", (Throwable)e);
        }
        Assertions.assertNotEquals((Object)TEST_ANNOTATION_ID, (Object)copied.getId());
        this.testFields(annotation);
    }

    @Test
    public void testEdit() {
        Annotation annotation = this.createDefaultTestAnnotation();
        Annotation edit = null;
        try {
            edit = (Annotation)this.getAnnotationStore(this.getTestContent()).edit(annotation).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Exception not expected", (Throwable)e);
        }
        Assertions.assertEquals((Object)TEST_ANNOTATION_ID, (Object)edit.getId());
        this.testFields(annotation);
    }

    @Test
    public void testDelete() {
        Annotation annotation = this.createDefaultTestAnnotation();
        AnnotationStore annotationStore = this.getAnnotationStore(this.getTestContent());
        Assertions.assertTrue((boolean)annotationStore.getById(TEST_ANNOTATION_ID).isPresent());
        annotationStore.delete(annotation);
        Assertions.assertTrue((!annotationStore.getById(TEST_ANNOTATION_ID).isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCollection() {
        Annotation annotation = this.createDefaultTestAnnotation();
        Annotation annotation2 = this.createTestAnnotationWithId("ANNOTATION2");
        AnnotationStore annotationStore = this.getAnnotationStore(this.getTestContent());
        Assertions.assertEquals((long)2L, (long)annotationStore.getAll().count());
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        list.add(annotation);
        list.add(annotation2);
        annotationStore.delete(list);
        Assertions.assertTrue((!annotationStore.getById(TEST_ANNOTATION_ID).isPresent() ? 1 : 0) != 0);
        Assertions.assertTrue((!annotationStore.getById("ANNOTATION2").isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testGetAll() {
        Annotation annotation = this.createDefaultTestAnnotation();
        String annotation2Id = "Annotation2";
        Annotation annotation2 = this.createTestAnnotationWithId(annotation2Id);
        Map<String, Annotation> annotations = this.getAnnotationStore(this.getTestContent()).getAll().collect(Collectors.toMap(WithId::getId, a -> a));
        Assertions.assertTrue((boolean)annotations.containsKey(TEST_ANNOTATION_ID));
        Assertions.assertTrue((boolean)annotations.containsKey(annotation2Id));
        Annotation testAnnotation1 = annotations.get(TEST_ANNOTATION_ID);
        Assertions.assertEquals((Object)TEST_ANNOTATION_ID, (Object)testAnnotation1.getId());
        this.testFields(testAnnotation1);
        Annotation testAnnotation2 = annotations.get(annotation2Id);
        Assertions.assertEquals((Object)annotation2Id, (Object)testAnnotation2.getId());
        this.testFields(testAnnotation1);
    }

    @Test
    public void testDeleteAll() {
        this.createDefaultTestAnnotation();
        this.createTestAnnotationWithId("annotation2");
        AnnotationStore annotationStore = this.getAnnotationStore(this.getTestContent());
        Assertions.assertEquals((long)2L, (long)annotationStore.getAll().count());
        annotationStore.deleteAll();
        Assertions.assertEquals((long)0L, (long)annotationStore.getAll().count());
    }

    @Test
    public void testGetByType() {
        this.createDefaultTestAnnotation();
        String annotation2Id = "2id";
        String type = "diffType";
        this.createTestAnnotation(annotation2Id, type, TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE);
        AnnotationStore annotationStore = this.getAnnotationStore(this.getTestContent());
        Assertions.assertEquals((long)2L, (long)annotationStore.getAll().count());
        List byType = annotationStore.getByType(type).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)byType.size());
        Annotation typeResult = (Annotation)byType.get(0);
        Assertions.assertEquals((Object)annotation2Id, (Object)typeResult.getId());
        Assertions.assertEquals((Object)type, (Object)typeResult.getType());
    }

    @Test
    public void testGetByBounds() {
        this.createDefaultTestAnnotation();
        AnnotationStore annotationStore = this.getAnnotationStore(this.getTestContent());
        List results = annotationStore.getByBounds(TestBounds.class).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)results.size());
    }

    private void testFields(Annotation annotation) {
        Assertions.assertEquals((Object)TEST_ANNOTATION_TYPE, (Object)annotation.getType());
        Assertions.assertTrue((boolean)annotation.getProperties().has(TEST_PROPERTY_KEY));
        Optional expected = annotation.getProperties().get(TEST_PROPERTY_KEY);
        Assertions.assertTrue((boolean)expected.isPresent());
        Assertions.assertEquals(expected.get(), (Object)TEST_PROPERTY_VALUE);
        Assertions.assertEquals((long)1L, (long)annotation.getProperties().keys().count());
        Assertions.assertEquals((Object)this.bounds, (Object)annotation.getBounds());
    }

    private void testBuilder(Annotation.Builder builder) {
        Annotation annotation = this.createDefaultTestAnnotation();
        Assertions.assertEquals((Object)TEST_ANNOTATION_ID, (Object)annotation.getId());
        this.testFields(annotation);
    }

    private void testIncompleteBuilder(Annotation.Builder builder) {
        try {
            builder.save();
        }
        catch (IncompleteException e) {
            return;
        }
        Assertions.fail((String)"Code should not reach here, exception should be thrown");
    }

    private Annotation createDefaultTestAnnotation() {
        return this.createTestAnnotation(TEST_ANNOTATION_ID, TEST_ANNOTATION_TYPE, TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE);
    }

    private Annotation createTestAnnotationWithId(String id) {
        return this.createTestAnnotation(id, TEST_ANNOTATION_TYPE, TEST_PROPERTY_KEY, TEST_PROPERTY_VALUE);
    }

    private Annotation createTestAnnotation(String id, String type, String key, String value) {
        Annotation annotation = null;
        try {
            annotation = (Annotation)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)this.getAnnotationStore(this.getTestContent()).create().withId(id)).withType(type)).withProperty(key, (Object)value)).withBounds((Bounds)this.bounds).save();
        }
        catch (IncompleteException e) {
            Assertions.fail((String)"Exception is not expected", (Throwable)e);
        }
        return annotation;
    }
}

