/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.defaultimpl.stores;

import io.annot8.common.implementations.delegates.DelegateAnnotationBuilder;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.stores.AnnotationStore;
import io.annot8.defaultimpl.annotations.DefaultAnnotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultAnnotationStore
implements AnnotationStore {
    private final Map<String, Annotation> annotations = new ConcurrentHashMap<String, Annotation>();
    private final String contentId;

    public DefaultAnnotationStore(String contentId) {
        this.contentId = contentId;
    }

    public Annotation.Builder getBuilder() {
        return new DelegateAnnotationBuilder(new DefaultAnnotation.Builder(this.contentId)){

            public Annotation save() throws IncompleteException {
                return DefaultAnnotationStore.this.save(super.save());
            }
        };
    }

    private Annotation save(Annotation annotation) {
        this.annotations.put(annotation.getId(), annotation);
        return annotation;
    }

    public void delete(Annotation annotation) {
        this.annotations.remove(annotation.getId(), annotation);
    }

    public Stream<Annotation> getAll() {
        return this.annotations.values().stream();
    }

    public Optional<Annotation> getById(String s) {
        return Optional.ofNullable(this.annotations.get(s));
    }

    public String toString() {
        return this.getClass().getName() + " [annotations=" + this.annotations.size() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.annotations);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationStore)) {
            return false;
        }
        AnnotationStore as = (AnnotationStore)obj;
        Set allAnnotations = as.getAll().collect(Collectors.toSet());
        return Objects.equals(new HashSet<Annotation>(this.annotations.values()), allAnnotations);
    }
}

