/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.defaultimpl.stores;

import io.annot8.common.implementations.stores.SaveCallback;
import io.annot8.core.annotations.Group;
import io.annot8.core.data.Item;
import io.annot8.core.stores.GroupStore;
import io.annot8.defaultimpl.annotations.DefaultGroup;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultGroupStore
implements GroupStore {
    private final Item item;
    private final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();

    public DefaultGroupStore(Item item) {
        this.item = item;
    }

    public Group.Builder getBuilder() {
        return new DefaultGroup.Builder(this.item, (SaveCallback<Group, Group>)((SaveCallback)this::save));
    }

    private Group save(Group group) {
        this.groups.put(group.getId(), group);
        return group;
    }

    public void delete(Group group) {
        this.groups.remove(group.getId(), group);
    }

    public Stream<Group> getAll() {
        return this.groups.values().stream();
    }

    public Optional<Group> getById(String s) {
        return Optional.ofNullable(this.groups.get(s));
    }

    public String toString() {
        return this.getClass().getName() + " [groups=" + this.groups.size() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.groups);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupStore)) {
            return false;
        }
        GroupStore gs = (GroupStore)obj;
        Set allGroups = gs.getAll().collect(Collectors.toSet());
        return Objects.equals(new HashSet<Group>(this.groups.values()), allGroups);
    }
}

