/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.defaultimpl.data;

import io.annot8.common.implementations.factories.ContentBuilderFactory;
import io.annot8.common.implementations.properties.MapMutableProperties;
import io.annot8.common.implementations.registries.ContentBuilderFactoryRegistry;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.data.ItemFactory;
import io.annot8.core.exceptions.UnsupportedContentException;
import io.annot8.core.properties.MutableProperties;
import io.annot8.core.stores.GroupStore;
import io.annot8.defaultimpl.stores.DefaultGroupStore;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class DefaultItem
implements Item {
    private final Map<String, Content<?>> contents = new ConcurrentHashMap();
    private final MutableProperties properties = new MapMutableProperties();
    private final ContentBuilderFactoryRegistry contentBuilderFactoryRegistry;
    private final DefaultGroupStore groups;
    private final String id;
    private final ItemFactory itemFactory;
    private final String parentId;
    private boolean discarded = false;

    public DefaultItem(ItemFactory itemFactory, String parentId, ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this.itemFactory = itemFactory;
        this.parentId = parentId;
        this.id = UUID.randomUUID().toString();
        this.contentBuilderFactoryRegistry = contentBuilderFactoryRegistry;
        this.groups = new DefaultGroupStore(this);
    }

    public DefaultItem(ItemFactory itemFactory, ContentBuilderFactoryRegistry contentBuilderFactoryRegistry) {
        this(itemFactory, null, contentBuilderFactoryRegistry);
    }

    public Optional<String> getParent() {
        return Optional.ofNullable(this.parentId);
    }

    public Optional<Content<?>> getContent(String id) {
        return Optional.ofNullable(this.contents.get(id));
    }

    public Stream<Content<?>> getContents() {
        return this.contents.values().stream();
    }

    public <C extends Content<D>, D> Content.Builder<C, D> create(Class<C> clazz) throws UnsupportedContentException {
        Optional factory = this.contentBuilderFactoryRegistry.get(clazz);
        if (!factory.isPresent()) {
            throw new UnsupportedContentException("Unknown content type: " + clazz.getSimpleName());
        }
        return ((ContentBuilderFactory)factory.get()).create((Item)this, this::save);
    }

    private <D, C extends Content<D>> C save(C c) {
        assert (c != null);
        this.contents.put(c.getId(), c);
        return c;
    }

    public void removeContent(String name) {
        this.contents.remove(name);
    }

    public Item createChildItem() {
        return this.itemFactory.create((Item)this);
    }

    public GroupStore getGroups() {
        return this.groups;
    }

    public MutableProperties getProperties() {
        return this.properties;
    }

    public void discard() {
        this.discarded = true;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public String getId() {
        return this.id;
    }
}

