/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.defaultimpl.annotations;

import io.annot8.common.implementations.annotations.AbstractGroup;
import io.annot8.common.implementations.properties.MapImmutableProperties;
import io.annot8.common.implementations.properties.MapMutableProperties;
import io.annot8.common.implementations.stores.SaveCallback;
import io.annot8.common.utils.properties.EmptyImmutableProperties;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.annotations.Group;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.properties.MutableProperties;
import io.annot8.core.properties.Properties;
import io.annot8.core.references.AnnotationReference;
import io.annot8.defaultimpl.references.DefaultAnnotationReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultGroup
extends AbstractGroup {
    private final Item item;
    private final String id;
    private final String type;
    private final ImmutableProperties properties;
    private final Map<DefaultAnnotationReference, String> annotations;

    private DefaultGroup(Item item, String id, String type, ImmutableProperties properties, Map<DefaultAnnotationReference, String> annotations) {
        this.item = item;
        this.id = id;
        this.type = type;
        this.properties = properties;
        this.annotations = annotations;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public Map<String, Stream<AnnotationReference>> getReferences() {
        HashMap<String, Stream<AnnotationReference>> ret = new HashMap<String, Stream<AnnotationReference>>();
        this.annotations.forEach((key, value) -> {
            Stream s = ret.getOrDefault(value, Stream.empty());
            ret.put((String)value, (Stream<AnnotationReference>)Stream.concat(s, Stream.of(key)));
        });
        return ret;
    }

    public Optional<String> getRole(Annotation annotation) {
        return Optional.ofNullable(this.annotations.get((Object)DefaultAnnotationReference.to(this.item, annotation)));
    }

    public boolean containsAnnotation(Annotation annotation) {
        return this.annotations.containsKey((Object)DefaultAnnotationReference.to(this.item, annotation));
    }

    public static class Builder
    implements Group.Builder {
        private final Item item;
        private final SaveCallback<Group, Group> saver;
        private String id;
        private String type = null;
        private MutableProperties properties = new MapMutableProperties();
        private Map<Annotation, String> annotations = new HashMap<Annotation, String>();

        public Builder(Item item, SaveCallback<Group, Group> saver) {
            this(item, null, saver);
        }

        public Builder(Item item, String id, SaveCallback<Group, Group> saver) {
            this.item = item;
            this.id = id;
            this.saver = saver;
        }

        public Group.Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Group.Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Group.Builder withProperty(String key, Object value) {
            this.properties.set(key, value);
            return this;
        }

        public Group.Builder withoutProperty(String key, Object value) {
            Optional val = this.properties.get(key);
            if (val.isPresent() && val.get().equals(value)) {
                this.properties.remove(key);
            }
            return this;
        }

        public Group.Builder withoutProperty(String key) {
            this.properties.remove(key);
            return this;
        }

        public Group.Builder withProperties(Properties properties) {
            this.properties = new MapMutableProperties(properties);
            return this;
        }

        public Group.Builder newId() {
            this.id = null;
            return this;
        }

        public Group.Builder from(Group from) {
            this.id = from.getId();
            this.type = from.getType();
            this.properties = new MapMutableProperties((Properties)from.getProperties());
            this.annotations = new HashMap<Annotation, String>();
            from.getAnnotations().forEach((key, value) -> value.forEach(a -> this.annotations.put((Annotation)a, (String)key)));
            return this;
        }

        public Group save() throws IncompleteException {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            if (this.type == null) {
                throw new IncompleteException("Type has not been set");
            }
            Object immutableProperties = this.properties.getAll().isEmpty() ? EmptyImmutableProperties.getInstance() : (ImmutableProperties)new MapImmutableProperties.Builder().from((Properties)this.properties).save();
            Map<DefaultAnnotationReference, String> references = this.annotations.entrySet().stream().collect(Collectors.toMap(e -> DefaultAnnotationReference.to(this.item, (Annotation)e.getKey()), Map.Entry::getValue));
            DefaultGroup group = new DefaultGroup(this.item, this.id, this.type, (ImmutableProperties)immutableProperties, references);
            return (Group)this.saver.save((Object)group);
        }

        public Group.Builder withAnnotation(String role, Annotation annotation) {
            this.annotations.put(annotation, role);
            return this;
        }
    }
}

