/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.defaultimpl.annotations;

import io.annot8.common.implementations.annotations.AbstractAnnotation;
import io.annot8.common.implementations.properties.MapImmutableProperties;
import io.annot8.common.implementations.properties.MapMutableProperties;
import io.annot8.common.implementations.stores.SaveCallback;
import io.annot8.common.utils.properties.EmptyImmutableProperties;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.properties.MutableProperties;
import io.annot8.core.properties.Properties;
import java.util.Optional;
import java.util.UUID;

public class DefaultAnnotation
extends AbstractAnnotation {
    private final String id;
    private final String type;
    private final ImmutableProperties properties;
    private final Bounds bounds;
    private final String content;

    private DefaultAnnotation(String id, String type, ImmutableProperties properties, Bounds bounds, String content) {
        this.id = id;
        this.type = type;
        this.properties = properties;
        this.bounds = bounds;
        this.content = content;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public String getContentId() {
        return this.content;
    }

    public static class Builder
    implements Annotation.Builder {
        private final SaveCallback<Annotation, Annotation> saver;
        private final String content;
        private String type = null;
        private MutableProperties properties = new MapMutableProperties();
        private Bounds bounds = null;
        private String id = null;

        public Builder(String content, SaveCallback<Annotation, Annotation> saver) {
            this.content = content;
            this.saver = saver;
        }

        public Annotation.Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Annotation.Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Annotation.Builder withProperty(String key, Object value) {
            this.properties.set(key, value);
            return this;
        }

        public Annotation.Builder withoutProperty(String key, Object value) {
            Optional val = this.properties.get(key);
            if (val.isPresent() && val.get().equals(value)) {
                this.properties.remove(key);
            }
            return this;
        }

        public Annotation.Builder withoutProperty(String key) {
            this.properties.remove(key);
            return this;
        }

        public Annotation.Builder withProperties(Properties properties) {
            this.properties = new MapMutableProperties(properties);
            return this;
        }

        public Annotation.Builder newId() {
            this.id = null;
            return this;
        }

        public Annotation.Builder from(Annotation from) {
            this.id = from.getId();
            this.type = from.getType();
            this.properties = new MapMutableProperties((Properties)from.getProperties());
            this.bounds = from.getBounds();
            return this;
        }

        public Annotation save() throws IncompleteException {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            if (this.type == null) {
                throw new IncompleteException("Type has not been set");
            }
            if (this.bounds == null) {
                throw new IncompleteException("Bounds has not been set");
            }
            if (this.content == null) {
                throw new IncompleteException("Content name has not been set");
            }
            Object immutableProperties = this.properties.getAll().isEmpty() ? EmptyImmutableProperties.getInstance() : (ImmutableProperties)new MapImmutableProperties.Builder().from((Properties)this.properties).save();
            DefaultAnnotation annotation = new DefaultAnnotation(this.id, this.type, (ImmutableProperties)immutableProperties, this.bounds, this.content);
            return (Annotation)this.saver.save((Object)annotation);
        }

        public Annotation.Builder withBounds(Bounds bounds) {
            this.bounds = bounds;
            return this;
        }
    }
}

