/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.defaultimpl;

import io.annot8.common.implementations.factories.ItemCreator;
import io.annot8.common.implementations.pipelines.ItemQueue;
import io.annot8.common.implementations.pipelines.Pipeline;
import io.annot8.common.implementations.pipelines.PipelineBuilder;
import io.annot8.common.implementations.pipelines.SimpleItemQueue;
import io.annot8.common.implementations.pipelines.SimplePipelineBuilder;
import io.annot8.common.implementations.registries.ContentBuilderFactoryRegistry;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.defaultimpl.factories.DefaultContentBuilderFactoryRegistry;
import io.annot8.defaultimpl.factories.DefaultItemCreator;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Annot8PipelineApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(Annot8PipelineApplication.class);
    private final Consumer<PipelineBuilder> pipelineBuilderConsumer;
    private final Consumer<ContentBuilderFactoryRegistry> contentBuilderFactoryRegistryConsumer;

    public Annot8PipelineApplication(Consumer<PipelineBuilder> pipelineBuilderConsumer) {
        this(pipelineBuilderConsumer, c -> {});
    }

    public Annot8PipelineApplication(Consumer<PipelineBuilder> pipelineBuilderConsumer, Consumer<ContentBuilderFactoryRegistry> contentBuilderFactoryRegistryConsumer) {
        this.pipelineBuilderConsumer = pipelineBuilderConsumer;
        this.contentBuilderFactoryRegistryConsumer = contentBuilderFactoryRegistryConsumer;
    }

    public void run() {
        try {
            Pipeline pipeline = this.buildPipeline();
            this.runPipeline(pipeline);
        }
        catch (Exception e) {
            LOGGER.error("Unable to run pipeline", (Throwable)e);
        }
    }

    private void runPipeline(Pipeline pipeline) throws Exception {
        try (Pipeline pipeline2 = pipeline;){
            pipeline.run();
        }
    }

    private Pipeline buildPipeline() throws IncompleteException {
        SimplePipelineBuilder builder = new SimplePipelineBuilder();
        builder = this.configureBuilder((PipelineBuilder)builder);
        if (this.pipelineBuilderConsumer != null) {
            this.pipelineBuilderConsumer.accept((PipelineBuilder)builder);
        }
        return builder.build();
    }

    private PipelineBuilder configureBuilder(PipelineBuilder builder) {
        DefaultContentBuilderFactoryRegistry contentBuilderFactoryRegistry = new DefaultContentBuilderFactoryRegistry();
        this.contentBuilderFactoryRegistryConsumer.accept((ContentBuilderFactoryRegistry)contentBuilderFactoryRegistry);
        SimpleItemQueue itemQueue = new SimpleItemQueue();
        return builder.withItemCreator((ItemCreator)new DefaultItemCreator((ContentBuilderFactoryRegistry)contentBuilderFactoryRegistry)).withItemQueue((ItemQueue)itemQueue);
    }

    public static void main() {
        new Annot8PipelineApplication(builder -> {}).run();
    }
}

