/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.types.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

@ComponentName(value="Change Type")
@ComponentDescription(value="Change the type of an annotation")
@SettingsClass(value=Settings.class)
public class ChangeType
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getOriginalType(), settings.getNewType(), settings.getRetainOriginal());
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesAnnotations(((Settings)this.getSettings()).getOriginalType(), Bounds.class).withCreatesAnnotations(((Settings)this.getSettings()).getNewType(), Bounds.class);
        if (!((Settings)this.getSettings()).getRetainOriginal()) {
            builder = builder.withDeletesAnnotations(((Settings)this.getSettings()).getOriginalType(), Bounds.class);
        }
        return builder.build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private final String originalType;
        private final String newType;
        private final boolean retainOriginal;

        public Settings(String originalType, String newType) {
            this.originalType = originalType;
            this.newType = newType;
            this.retainOriginal = false;
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="originalType") String originalType, @JsonbProperty(value="newType") String newType, @JsonbProperty(value="retainOriginal") boolean retainOriginal) {
            this.originalType = originalType;
            this.newType = newType;
            this.retainOriginal = retainOriginal;
        }

        @Description(value="The original type to change")
        public String getOriginalType() {
            return this.originalType;
        }

        @Description(value="The type to change to")
        public String getNewType() {
            return this.newType;
        }

        @Description(value="Whether the original annotation should be retained (true) or removed (false)")
        public boolean getRetainOriginal() {
            return this.retainOriginal;
        }

        public boolean validate() {
            return this.originalType != null && this.newType != null;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String originalType;
        private final String newType;
        private final boolean retainOriginal;

        public Processor(String originalType, String newType, boolean retainOriginal) {
            this.originalType = originalType;
            this.newType = newType;
            this.retainOriginal = retainOriginal;
        }

        public ProcessorResponse process(Item item) {
            item.getContents().forEach(c -> c.getAnnotations().getByType(this.originalType).forEach(a -> {
                try {
                    if (this.retainOriginal) {
                        ((Annotation.Builder)c.getAnnotations().copy(a).withType(this.newType)).save();
                    } else {
                        ((Annotation.Builder)c.getAnnotations().edit(a).withType(this.newType)).save();
                    }
                }
                catch (IncompleteException ie) {
                    this.log().warn("Unable to copy annotation", (Throwable)ie);
                }
            }));
            return ProcessorResponse.ok();
        }
    }
}

