/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObject;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.ContentBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

@ComponentName(value="Detect Language")
@ComponentDescription(value="Detect the language of text content")
public class DetectLanguage
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/language", ContentBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final LanguageDetector languageDetector;

        public Processor(LanguageDetector languageDetector) {
            this.languageDetector = languageDetector;
        }

        public Processor() {
            List languageProfiles;
            try {
                languageProfiles = new LanguageProfileReader().readAllBuiltIn();
            }
            catch (IOException ioe) {
                throw new Annot8RuntimeException("Could not read built in language profiles");
            }
            this.languageDetector = LanguageDetectorBuilder.create((NgramExtractor)NgramExtractors.standard()).withProfiles((Iterable)languageProfiles).build();
        }

        public void process(Text text) {
            TextObject textObject = CommonTextObjectFactories.forDetectingOnLargeText().forText((CharSequence)text.getData());
            Optional lang = this.languageDetector.detect((CharSequence)textObject).toJavaUtil();
            if (lang.isPresent()) {
                ((Annotation.Builder)((Annotation.Builder)text.getAnnotations().create().withType("entity/language")).withBounds((Bounds)ContentBounds.getInstance()).withProperty("language", (Object)((LdLocale)lang.get()).getLanguage())).save();
            }
        }
    }
}

