/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.quantities.processors.AbstractQuantityProcessor;
import java.util.regex.Pattern;

@ComponentName(value="Area")
@ComponentDescription(value="Extract area from text")
@ComponentTags(value={"quantity", "area", "text"})
public class Area
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/quantity/area", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractQuantityProcessor {
        private static final double MM2_TO_M2 = 1.0E-6;
        private static final double CM2_TO_M2 = 1.0E-4;
        private static final double KM2_TO_M2 = 1000000.0;
        private static final double MI2_TO_M2 = 2589988.1;
        private static final double YD2_TO_M2 = 0.83612739;
        private static final double FT2_TO_M2 = 0.092903044;
        private static final double IN2_TO_M2 = 6.4516E-4;
        private static final double ACRE_TO_M2 = 4046.8564;
        private static final double HECTARE_TO_M2 = 10000.0;
        private final Pattern m2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(m\\^2|square metre|square meter|square m)(s)?\\b", 2);
        private final Pattern mm2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(mm\\^2|square millimetre|square millimeter|square mm)(s)?\\b", 2);
        private final Pattern cm2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(cm\\^2|square centimetre|square centimeter|square cm)(s)?\\b", 2);
        private final Pattern km2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(km\\^2|square kilometre|square kilometers|square km)(s)?\\b", 2);
        private final Pattern mi2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(mi\\^2|square miles|square mi)(s)?\\b", 2);
        private final Pattern yd2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(yd\\^2|square yard|square yd)(s)?\\b", 2);
        private final Pattern ft2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(ft\\^2|square foot|square feet|square ft)(s)?\\b", 2);
        private final Pattern in2Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(in\\^2|square inch|square in|square inche)(s)?\\b", 2);
        private final Pattern haPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(hectare|ha)(s)?\\b", 2);
        private final Pattern acrePattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(acre)(s)?\\b", 2);

        public Processor() {
            super("entity/quantity/area", "m^2");
            this.add(this.mm2Pattern, 1.0E-6);
            this.add(this.cm2Pattern, 1.0E-4);
            this.add(this.m2Pattern, 1.0);
            this.add(this.km2Pattern, 1000000.0);
            this.add(this.in2Pattern, 6.4516E-4);
            this.add(this.ft2Pattern, 0.092903044);
            this.add(this.yd2Pattern, 0.83612739);
            this.add(this.mi2Pattern, 2589988.1);
            this.add(this.acrePattern, 4046.8564);
            this.add(this.haPattern, 10000.0);
        }
    }
}

