/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.quantities.processors.AbstractQuantityProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Time Quantity")
@ComponentDescription(value="The document content is searched for things that might represent time periods using regular expressions.")
@ComponentTags(value={"quantity", "time", "temporal", "text"})
public class Time
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesAnnotations("entity/quantity", SpanBounds.class).withProcessesContent(Text.class).build();
    }

    public static class Processor
    extends AbstractQuantityProcessor {
        public static final int YEAR_TO_SECOND = 31536000;
        public static final int MONTH_TO_SECOND = 2628000;
        public static final int WEEK_TO_SECOND = 604800;
        public static final int DAY_TO_SECOND = 86400;
        public static final int HOUR_TO_SECOND = 3600;
        public static final int MINUTE_TO_SECOND = 60;
        public static final String UNIT = "s";
        private final Pattern yearPattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(year|yr)(s)?\\b", 2);
        private final Pattern monthPattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(month)(s)?\\b", 2);
        private final Pattern weekPattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(week|wk)(s)?\\b", 2);
        private final Pattern dayPattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(day)(s)?\\b", 2);
        private final Pattern hourPattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(hour|hr)(s)?\\b", 2);
        private final Pattern minutePattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(minute|min)(s)?\\b", 2);
        private final Pattern secondPattern = Pattern.compile("\\b([0-9]+([0-9,]+[0-9])?)[ ]?(second|sec)(s)?\\b", 2);

        public Processor() {
            super("entity/quantity", UNIT);
            this.add(this.yearPattern, 3.1536E7);
            this.add(this.monthPattern, 2628000.0);
            this.add(this.weekPattern, 604800.0);
            this.add(this.dayPattern, 86400.0);
            this.add(this.minutePattern, 60.0);
            this.add(this.secondPattern, 1.0);
        }

        @Override
        protected void process(Text content) {
            Matcher matcher = this.hourPattern.matcher((CharSequence)content.getData());
            while (matcher.find()) {
                String q = matcher.group(1);
                if (q.length() == 4 && Integer.parseInt(q.substring(0, 2)) <= 23 && Integer.parseInt(q.substring(2)) <= 59) continue;
                ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withType("entity/quantity")).withBounds((Bounds)new SpanBounds(matcher.start(), matcher.end())).withProperty("value", (Object)(Double.parseDouble(matcher.group(1).replaceAll("[^0-9\\.]", "")) * 3600.0))).withProperty("unit", (Object)UNIT)).save();
            }
            super.process(content);
        }
    }
}

