/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Frequency")
@ComponentDescription(value="Extract frequencies from text")
@ComponentTags(value={"quantity", "frequency", "text"})
public class Frequency
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/frequency", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private static final Pattern frequencyPattern = Pattern.compile("\\b(\\d+(\\.\\d+)?)\\s*([mkMGT])?Hz\\b");

        protected void process(Text content) {
            Matcher m = frequencyPattern.matcher((CharSequence)content.getData());
            while (m.find()) {
                Annotation.Builder builder = ((Annotation.Builder)content.getAnnotations().create().withType("entity/frequency")).withBounds((Bounds)new SpanBounds(m.start(), m.end()));
                try {
                    Double value = Double.parseDouble(m.group(1));
                    double multiplier = 1.0;
                    if (m.group(3) != null) {
                        switch (m.group(3)) {
                            case "m": {
                                multiplier = 0.001;
                                break;
                            }
                            case "k": {
                                multiplier = 1000.0;
                                break;
                            }
                            case "M": {
                                multiplier = 1000000.0;
                                break;
                            }
                            case "G": {
                                multiplier = 1.0E9;
                                break;
                            }
                            case "T": {
                                multiplier = 1.0E12;
                            }
                        }
                    }
                    builder = (Annotation.Builder)((Annotation.Builder)builder.withProperty("value", (Object)(value * multiplier))).withProperty("unit", (Object)"Hz");
                }
                catch (Exception e) {
                    this.log().warn("Unable to parse and normalise value", (Throwable)e);
                    e.printStackTrace();
                }
                builder.save();
            }
        }
    }
}

