/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.quantities.processors.AbstractQuantityProcessor;
import java.util.regex.Pattern;

@ComponentName(value="Distance")
@ComponentDescription(value="Extract distances from text")
@ComponentTags(value={"quantity", "distance", "text"})
public class Distance
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/quantity/distance", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractQuantityProcessor {
        private static final double MI_TO_M = 1609.344;
        private static final double YD_TO_M = 0.9144;
        private static final double FT_TO_M = 0.3048;
        private static final double IN_TO_M = 0.0254;
        private static final double NM_TO_M = 1852.0;
        private final Pattern kmPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(km|kilometre|kilometer|click)(s)?\\b", 2);
        private final Pattern mPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(m|metre|meter)(s)?\\b", 2);
        private final Pattern cmPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(cm|centimetre|centimeter)(s)?\\b", 2);
        private final Pattern mmPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(mm|millimetre|millimeter)(s)?\\b", 2);
        private final Pattern miPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(mile)(s)?\\b", 2);
        private final Pattern ydPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(yard|yd)(s)?\\b", 2);
        private final Pattern ftPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(foot|feet|ft)\\b", 2);
        private final Pattern inPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(inch|inches)\\b", 2);
        private final Pattern nmPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(hundred|thousand|million|billion|trillion)?[ ]?(nm|nmi|nautical mile(s)?)\\b", 2);

        public Processor() {
            super("entity/quantity/distance", "m");
            this.add(this.mmPattern, 0.001);
            this.add(this.cmPattern, 0.01);
            this.add(this.mPattern, 1.0);
            this.add(this.kmPattern, 1000.0);
            this.add(this.inPattern, 0.0254);
            this.add(this.ftPattern, 0.3048);
            this.add(this.ydPattern, 0.9144);
            this.add(this.miPattern, 1609.344);
            this.add(this.nmPattern, 1852.0);
        }
    }
}

