/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.quantities.processors.AbstractQuantityProcessor;
import java.util.regex.Pattern;

@ComponentName(value="Volume")
@ComponentDescription(value="Extract volumes from text")
public class Volume
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/quantity/volume", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractQuantityProcessor {
        private static final double PINT_TO_M3 = 5.68E-4;
        private static final double GALLON_TO_M3 = 0.00454609;
        private final Pattern m3Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(m\\^3|cubic metre|cubic meter)(s)?\\b", 2);
        private final Pattern cm3Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(cm\\^3|cubic centimetre|cubic centimeter)(s)?\\b", 2);
        private final Pattern lPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(l|litre|liter)(s)?\\b", 2);
        private final Pattern mlPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(ml|millilitre|milliliter)(s)?\\b", 2);
        private final Pattern pintPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(pt|pint)(s)?\\b", 2);
        private final Pattern gallonPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(gal|gallon)(s)?\\b", 2);

        public Processor() {
            super("entity/quantity/volume", "m^3");
            this.add(this.cm3Pattern, 1.0E-6);
            this.add(this.m3Pattern, 1.0);
            this.add(this.mlPattern, 1.0E-6);
            this.add(this.lPattern, 0.001);
            this.add(this.pintPattern, 5.68E-4);
            this.add(this.gallonPattern, 0.00454609);
        }
    }
}

