/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.quantities.processors.AbstractQuantityProcessor;
import java.util.regex.Pattern;

@ComponentName(value="Mass")
@ComponentDescription(value="Extract mass from text")
public class Mass
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/quantity/mass", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractQuantityProcessor {
        private static final double LONG_TON_TO_KG = 1016.0469088;
        private static final double STONE_TO_KG = 6.35029318;
        private static final double POUNDS_TO_KG = 0.45359237;
        private static final double OUNCES_TO_KG = 0.028349523125;
        private final Pattern tonnePattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(tonne)(s)?\\b", 2);
        private final Pattern kgPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(kg|kilogram|kilo)(s)?\\b", 2);
        private final Pattern gPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(g|gram)(s)?\\b", 2);
        private final Pattern mgPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(mg|milligram)(s)?\\b", 2);
        private final Pattern tonPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(ton)(s)?\\b", 2);
        private final Pattern lbPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(lb)(s)?\\b", 2);
        private final Pattern stonePattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(st|stone)(s)?\\b", 2);
        private final Pattern ozPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(oz|ounce)(s)?\\b", 2);

        public Processor() {
            super("entity/quantity/mass", "kg");
            this.add(this.tonnePattern, 1000.0);
            this.add(this.kgPattern, 1.0);
            this.add(this.gPattern, 0.001);
            this.add(this.mgPattern, 1.0E-6);
            this.add(this.tonPattern, 1016.0469088);
            this.add(this.lbPattern, 0.45359237);
            this.add(this.stonePattern, 6.35029318);
            this.add(this.ozPattern, 0.028349523125);
        }
    }
}

