/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.capabilities.Capabilities;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractQuantityProcessor
extends AbstractTextProcessor {
    private final String annotationType;
    private final String normalizedUnit;
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final List<Double> normalizationConstants = new ArrayList<Double>();

    public AbstractQuantityProcessor(String annotationType, String normalizedUnit) {
        this.annotationType = annotationType;
        this.normalizedUnit = normalizedUnit;
    }

    protected void add(Pattern pattern, double normalizationConstant) {
        this.patterns.add(pattern);
        this.normalizationConstants.add(normalizationConstant);
    }

    protected void process(Item item, Text content) throws Annot8Exception {
        for (int i = 0; i < this.patterns.size(); ++i) {
            this.process(content, this.patterns.get(i), this.normalizationConstants.get(i));
        }
    }

    protected void process(Text content, Pattern pattern, double normalization) throws Annot8Exception {
        Matcher m = pattern.matcher((CharSequence)content.getData());
        while (m.find()) {
            Annotation.Builder builder = ((Annotation.Builder)content.getAnnotations().create().withType(this.annotationType)).withBounds((Bounds)new SpanBounds(m.start(), m.end()));
            try {
                builder = (Annotation.Builder)((Annotation.Builder)builder.withProperty("value", (Object)AbstractQuantityProcessor.normalise(m.group(1), m.group(2), normalization))).withProperty("unit", (Object)this.normalizedUnit);
            }
            catch (Exception e) {
                this.log().warn("Unable to parse and normalise value", (Throwable)e);
            }
            builder.save();
        }
    }

    private static double normalise(String number, String multiplier, double normalization) {
        double n = Double.parseDouble(number.replaceAll("[^0-9\\.]", ""));
        long m = 1L;
        if (multiplier != null) {
            switch (multiplier.toLowerCase()) {
                case "thousand": {
                    m = 1000L;
                    break;
                }
                case "million": {
                    m = 1000000L;
                    break;
                }
                case "billion": {
                    m = 1000000000L;
                    break;
                }
                case "trillion": {
                    m = 1000000000000L;
                }
            }
        }
        return n * (double)m * normalization;
    }

    public void buildCapabilities(Capabilities.Builder builder) {
        super.buildCapabilities(builder);
        builder.createsAnnotation(this.annotationType, SpanBounds.class);
    }
}

