/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.components.quantities.processors.AbstractQuantityProcessor;
import java.util.regex.Pattern;

public class Volume
extends AbstractQuantityProcessor {
    private static final double PINT_TO_M3 = 5.68E-4;
    private static final double GALLON_TO_M3 = 0.00454609;
    private final Pattern m3Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(m\\^3|cubic metre|cubic meter)(s)?\\b", 2);
    private final Pattern cm3Pattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(cm\\^3|cubic centimetre|cubic centimeter)(s)?\\b", 2);
    private final Pattern lPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(l|litre|liter)(s)?\\b", 2);
    private final Pattern mlPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(ml|millilitre|milliliter)(s)?\\b", 2);
    private final Pattern pintPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(pt|pint)(s)?\\b", 2);
    private final Pattern gallonPattern = Pattern.compile("\\b([0-9]+([0-9\\.,]+[0-9])?)[ ]?(thousand|million|billion|trillion)?[ ]?(gal|gallon)(s)?\\b", 2);

    public Volume() {
        super("volume", "m^3");
        this.add(this.cm3Pattern, 1.0E-6);
        this.add(this.m3Pattern, 1.0);
        this.add(this.mlPattern, 1.0E-6);
        this.add(this.lPattern, 0.001);
        this.add(this.pintPattern, 5.68E-4);
        this.add(this.gallonPattern, 0.00454609);
    }
}

