/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.quantities.processors;

import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Frequency
extends AbstractTextProcessor {
    private static final Pattern frequencyPattern = Pattern.compile("\\b(\\d+(\\.\\d+)?)\\s*([mkMGT])?Hz\\b");

    protected void process(Item item, Text content) throws Annot8Exception {
        Matcher m = frequencyPattern.matcher((CharSequence)content.getData());
        while (m.find()) {
            Annotation.Builder builder = ((Annotation.Builder)content.getAnnotations().create().withType("frequency")).withBounds((Bounds)new SpanBounds(m.start(), m.end()));
            try {
                Double value = Double.parseDouble(m.group(1));
                double multiplier = 1.0;
                if (m.group(3) != null) {
                    switch (m.group(3)) {
                        case "m": {
                            multiplier = 0.001;
                            break;
                        }
                        case "k": {
                            multiplier = 1000.0;
                            break;
                        }
                        case "M": {
                            multiplier = 1000000.0;
                            break;
                        }
                        case "G": {
                            multiplier = 1.0E9;
                            break;
                        }
                        case "T": {
                            multiplier = 1.0E12;
                        }
                    }
                }
                builder = (Annotation.Builder)((Annotation.Builder)builder.withProperty("value", (Object)(value * multiplier))).withProperty("unit", (Object)"Hz");
            }
            catch (Exception e) {
                this.log().warn("Unable to parse and normalise value", (Throwable)e);
                e.printStackTrace();
            }
            builder.save();
        }
    }
}

