/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.sources;

import com.mongodb.client.MongoCursor;
import io.annot8.components.mongo.AbstractMongoComponent;
import io.annot8.components.mongo.data.MongoDocument;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.components.Source;
import io.annot8.core.components.responses.SourceResponse;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.data.ItemFactory;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.exceptions.UnsupportedContentException;
import java.time.Instant;
import org.bson.Document;

@CreatesContent(value=MongoDocument.class)
public class MongoSource
extends AbstractMongoComponent
implements Source {
    private MongoCursor<Document> cursor = null;

    @Override
    public void configure(Context context, MongoConnection connection) {
        this.cursor = connection.getCollection().find().iterator();
    }

    public SourceResponse read(ItemFactory itemFactory) {
        if (this.cursor == null) {
            this.log().warn("Cursor is null, has configure been called?");
            return SourceResponse.sourceError();
        }
        if (!this.cursor.hasNext()) {
            this.cursor.close();
            return SourceResponse.done();
        }
        Document doc = (Document)this.cursor.next();
        Item item = itemFactory.create();
        try {
            item.getProperties().set("accessedAt", (Object)Instant.now().getEpochSecond());
            item.create(MongoDocument.class).withName("document").withData((Object)doc).save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            this.log().warn("Couldn't create item", e);
            item.discard();
            return SourceResponse.sourceError();
        }
        return SourceResponse.ok();
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.close();
    }
}

