/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.sinks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.MongoCollection;
import io.annot8.components.mongo.data.AnnotationDto;
import io.annot8.components.mongo.data.ContentDto;
import io.annot8.components.mongo.data.ItemDto;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.components.mongo.sinks.AbstractMongoSink;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class NestedItemSink
extends AbstractMongoSink {
    private MongoCollection<Document> itemCollection;

    @Override
    public void storeItem(Item item) throws Annot8Exception {
        ItemDto itemDto = this.toDto(item);
        try {
            this.itemCollection.insertOne((Object)this.toMongoDocument(itemDto));
        }
        catch (JsonProcessingException e) {
            this.log().error("Error converting item to mongo document", (Throwable)e);
            throw new Annot8Exception("Error storing item", (Throwable)e);
        }
    }

    @Override
    protected void configureMongo(MongoConnection connection) {
        this.itemCollection = connection.getCollection();
        this.itemCollection.createIndex((Bson)new Document("id", (Object)1));
    }

    private ItemDto toDto(Item item) {
        String parentId = item.getParent().orElse(null);
        return new ItemDto(item.getId(), parentId, item.getProperties().getAll(), this.getContents(item));
    }

    private Collection<ContentDto> getContents(Item item) {
        return item.getContents().map(c -> this.toDto((Content)c, item.getId())).collect(Collectors.toList());
    }

    private Collection<AnnotationDto> getAnnotations(Content content, String itemId) {
        return content.getAnnotations().getAll().map(a -> this.toDto((Annotation)a, content, itemId)).collect(Collectors.toList());
    }

    private ContentDto toDto(Content content, String itemId) {
        return new ContentDto(content.getId(), content.getName(), content.getData(), this.sanitiseKeys(content.getProperties()), this.getAnnotations(content, itemId), itemId, content.getContentClass().getSimpleName());
    }

    private AnnotationDto toDto(Annotation annotation, Content content, String itemId) {
        Object data = null;
        Optional optional = annotation.getBounds().getData(content);
        if (optional.isPresent()) {
            data = optional.get();
        }
        return new AnnotationDto(annotation.getId(), annotation.getType(), annotation.getBounds(), data, this.sanitiseKeys(annotation.getProperties()), content.getId(), itemId);
    }
}

