/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.sinks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.annot8.components.mongo.data.AnnotationDto;
import io.annot8.components.mongo.data.ContentDto;
import io.annot8.components.mongo.data.ItemDto;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.components.mongo.sinks.AbstractMongoSink;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FlatMongoSink
extends AbstractMongoSink {
    private static final String ITEM = "item";
    private static final String CONTENT = "content";
    private static final String ANNOTATION = "annotation";
    private MongoCollection<Document> itemCollection;
    private MongoCollection<Document> contentsCollection;
    private MongoCollection<Document> annotationsCollection;

    @Override
    public void storeItem(Item item) throws Annot8Exception {
        String parentId = null;
        if (item.getParent().isPresent()) {
            parentId = (String)item.getParent().get();
        }
        ItemDto itemDto = new ItemDto(item.getId(), parentId, item.getProperties().getAll(), null);
        Collection contents = item.getContents().map(c -> new ContentDto(c.getId(), c.getName(), c.getData(), this.sanitiseKeys(c.getProperties()), null, item.getId(), c.getContentClass().getSimpleName())).collect(Collectors.toList());
        Collection annotations = item.getContents().flatMap(c -> this.getAnnotations((Content)c, item)).collect(Collectors.toList());
        Document itemDocument = null;
        ArrayList<Document> contentDocuments = null;
        ArrayList<Document> annotationDocuments = null;
        try {
            itemDocument = this.toMongoDocument(itemDto);
            contentDocuments = new ArrayList<Document>();
            annotationDocuments = new ArrayList<Document>();
            for (ContentDto content : contents) {
                contentDocuments.add(this.toMongoDocument(content));
            }
            for (AnnotationDto annotation : annotations) {
                annotationDocuments.add(this.toMongoDocument(annotation));
            }
        }
        catch (JsonProcessingException e) {
            this.log().error("Error converting object to document", (Throwable)e);
            throw new Annot8Exception("Error storing item", (Throwable)e);
        }
        this.itemCollection.insertOne((Object)itemDocument);
        if (!contentDocuments.isEmpty()) {
            this.contentsCollection.insertMany(contentDocuments);
        }
        if (!annotationDocuments.isEmpty()) {
            this.annotationsCollection.insertMany(annotationDocuments);
        }
    }

    private Stream<AnnotationDto> getAnnotations(Content content, Item item) {
        return content.getAnnotations().getAll().map(a -> this.getAnnotation((Annotation)a, content, item));
    }

    private AnnotationDto getAnnotation(Annotation annotation, Content content, Item item) {
        Object data = null;
        Optional optionalData = annotation.getBounds().getData(content, Object.class);
        if (optionalData.isPresent()) {
            data = optionalData.get();
        }
        return new AnnotationDto(annotation.getId(), annotation.getType(), annotation.getBounds(), data, this.sanitiseKeys(annotation.getProperties()), content.getId(), item.getId());
    }

    @Override
    protected void configureMongo(MongoConnection connection) {
        MongoDatabase database = connection.getDatabase();
        this.itemCollection = database.getCollection(ITEM);
        this.contentsCollection = database.getCollection(CONTENT);
        this.annotationsCollection = database.getCollection(ANNOTATION);
        this.itemCollection.createIndex((Bson)new Document("id", (Object)1));
        this.contentsCollection.createIndex((Bson)new Document("id", (Object)1));
        this.contentsCollection.createIndex((Bson)new Document("itemId", (Object)1));
        this.annotationsCollection.createIndex((Bson)new Document("type", (Object)1));
        this.annotationsCollection.createIndex((Bson)new Document("id", (Object)1));
        this.annotationsCollection.createIndex((Bson)new Document("type", (Object)1));
        this.annotationsCollection.createIndex((Bson)new Document("itemId", (Object)1));
    }
}

