/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.sinks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.annot8.common.serialisation.jackson.Annot8ObjectMapperFactory;
import io.annot8.components.mongo.AbstractMongoComponent;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.components.mongo.resources.MongoFactory;
import io.annot8.core.capabilities.UsesResource;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.context.Context;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.properties.ImmutableProperties;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

@UsesResource(value=MongoFactory.class)
public abstract class AbstractMongoSink
extends AbstractMongoComponent
implements Processor {
    private ObjectMapper mapper;

    protected abstract void storeItem(Item var1) throws Annot8Exception;

    protected abstract void configureMongo(MongoConnection var1);

    @Override
    protected void configure(Context context, MongoConnection connection) {
        this.mapper = new ObjectMapper();
        Annot8ObjectMapperFactory factory = new Annot8ObjectMapperFactory();
        factory.scan();
        factory.configure(this.mapper);
        this.configureMongo(connection);
    }

    public ProcessorResponse process(Item item) {
        try {
            this.storeItem(item);
        }
        catch (Annot8Exception e) {
            this.log().error("Failed to store item", (Throwable)e);
            return ProcessorResponse.itemError();
        }
        return ProcessorResponse.ok();
    }

    protected Document toMongoDocument(Object object) throws JsonProcessingException {
        String json = this.mapper.writeValueAsString(object);
        return Document.parse((String)json);
    }

    protected Map<String, Object> sanitiseKeys(ImmutableProperties properties) {
        HashMap<String, Object> sanitisedProperties = new HashMap<String, Object>();
        properties.getAll().forEach((k, v) -> sanitisedProperties.put(k.replaceAll("\\.", "-"), v));
        return sanitisedProperties;
    }
}

