/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.resources;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.annot8.components.mongo.resources.MongoConnection;
import org.bson.Document;

public class SimpleMongoConnection
implements MongoConnection {
    private final MongoClient client;
    private final MongoDatabase database;
    private final MongoCollection<Document> collection;

    public SimpleMongoConnection(MongoClient client, MongoDatabase database, MongoCollection<Document> collection) {
        this.client = client;
        this.database = database;
        this.collection = collection;
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    public <T> MongoCollection getCollection(Class<T> clazz) {
        return this.getCollection().withDocumentClass(clazz);
    }

    @Override
    public MongoCollection getCollection() {
        return this.collection;
    }

    @Override
    public void disconnect() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

