/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.resources;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.components.mongo.resources.MongoConnectionSettings;
import io.annot8.components.mongo.resources.SimpleMongoConnection;
import io.annot8.core.components.Resource;
import io.annot8.core.context.Context;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.settings.SettingsClass;
import java.util.Optional;
import org.bson.Document;

@SettingsClass(value=MongoConnectionSettings.class, optional=true)
public class MongoFactory
extends AbstractComponent
implements Resource {
    private Optional<MongoConnectionSettings> defaultSettings = Optional.empty();

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        this.defaultSettings = context.getSettings(MongoConnectionSettings.class);
    }

    public Optional<MongoConnection> buildMongo(Optional<MongoConnectionSettings> settings) {
        try {
            MongoConnectionSettings mergedSettings = this.mergeWithDefaultSettings(settings);
            if (!mergedSettings.validate()) {
                throw new BadConfigurationException("MongoConnectionSettings are incomplete");
            }
            MongoClient client = this.buildClient(mergedSettings);
            MongoDatabase database = client.getDatabase(mergedSettings.getDatabase());
            MongoCollection collection = database.getCollection(mergedSettings.getCollection());
            return Optional.of(new SimpleMongoConnection(client, database, (MongoCollection<Document>)collection));
        }
        catch (BadConfigurationException e) {
            return Optional.empty();
        }
    }

    public MongoClient buildClient(MongoConnectionSettings settings) throws BadConfigurationException {
        if (settings == null || !settings.validateConnection()) {
            throw new BadConfigurationException("Connection settings are not valid");
        }
        return MongoClients.create((String)settings.getConnection());
    }

    public MongoConnectionSettings mergeWithDefaultSettings(Optional<MongoConnectionSettings> settings) {
        return MongoConnectionSettings.merge(settings, this.defaultSettings);
    }
}

