/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.resources;

import com.google.common.base.Strings;
import io.annot8.core.settings.Settings;
import java.util.Optional;
import java.util.stream.Stream;

public class MongoConnectionSettings
implements Settings {
    private String connection;
    private String database;
    private String collection;

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public boolean validate() {
        return this.validateConnection() && this.database != null && !this.database.isEmpty() && this.collection != null && !this.collection.isEmpty();
    }

    public boolean validateConnection() {
        return !Strings.isNullOrEmpty((String)this.connection) && (this.connection.startsWith("mongodb://") || this.connection.startsWith("mongodb+srv://"));
    }

    public MongoConnectionSettings merge(Optional<MongoConnectionSettings> settings) {
        if (settings.isPresent()) {
            MongoConnectionSettings s = settings.get();
            if (!this.validateConnection()) {
                this.connection = s.getConnection();
            }
            if (Strings.isNullOrEmpty((String)this.database)) {
                this.database = s.getDatabase();
            }
            if (Strings.isNullOrEmpty((String)this.collection)) {
                this.collection = s.getCollection();
            }
        }
        return this;
    }

    public static MongoConnectionSettings merge(Optional<MongoConnectionSettings> ... settings) {
        MongoConnectionSettings s = new MongoConnectionSettings();
        Stream.of(settings).forEach(s::merge);
        return s;
    }
}

