/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.resources;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.annot8.components.base.components.AbstractResource;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.components.mongo.resources.MongoConnectionSettings;
import io.annot8.components.mongo.resources.MongoFactory;
import io.annot8.core.context.Context;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import java.util.Optional;
import org.bson.Document;

public class Mongo
extends AbstractResource
implements MongoConnection {
    private MongoClient client;
    private MongoDatabase database;
    private MongoCollection<Document> collection;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        Optional mongoFactory = context.getResource(MongoFactory.class);
        if (!mongoFactory.isPresent()) {
            throw new MissingResourceException("MongoFactory is required");
        }
        Optional mongoSettings = context.getSettings(MongoConnectionSettings.class);
        if (!mongoSettings.isPresent()) {
            throw new BadConfigurationException("MongoConnectionSettings are required");
        }
        MongoConnectionSettings mergedSettings = ((MongoFactory)((Object)mongoFactory.get())).mergeWithDefaultSettings(mongoSettings);
        if (!mergedSettings.validate()) {
            throw new BadConfigurationException("MongoConnectionSettings are incomplete");
        }
        this.client = ((MongoFactory)((Object)mongoFactory.get())).buildClient(mergedSettings);
        this.database = this.client.getDatabase(mergedSettings.getDatabase());
        this.collection = this.database.getCollection(mergedSettings.getCollection());
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public MongoCollection getCollection() {
        return this.collection;
    }

    @Override
    public void disconnect() {
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

