/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo.data;

import io.annot8.common.implementations.content.AbstractContentBuilder;
import io.annot8.common.implementations.content.AbstractContentBuilderFactory;
import io.annot8.common.implementations.stores.AnnotationStoreFactory;
import io.annot8.core.data.BaseItem;
import io.annot8.core.data.Content;
import io.annot8.core.properties.ImmutableProperties;
import io.annot8.core.stores.AnnotationStore;
import java.util.function.Supplier;
import org.bson.Document;

public class MongoDocument
implements Content<Document> {
    private final String id;
    private final String name;
    private final AnnotationStore annotations;
    private final ImmutableProperties properties;
    private final Document document;

    public MongoDocument(String id, String name, AnnotationStoreFactory annotationStoreFactory, ImmutableProperties properties, Document document) {
        this.id = id;
        this.name = name;
        this.annotations = annotationStoreFactory.create((Content)this);
        this.properties = properties;
        this.document = document;
    }

    public Document getData() {
        return this.document;
    }

    public Class<Document> getDataClass() {
        return Document.class;
    }

    public Class<? extends Content<Document>> getContentClass() {
        return MongoDocument.class;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public static class BuilderFactory
    extends AbstractContentBuilderFactory<Document, MongoDocument> {
        private AnnotationStoreFactory annotationStoreFactory;

        protected BuilderFactory(AnnotationStoreFactory annotationStoreFactory) {
            super(Document.class, MongoDocument.class);
            this.annotationStoreFactory = annotationStoreFactory;
        }

        public Content.Builder<MongoDocument, Document> create(BaseItem item) {
            return new Builder(this.annotationStoreFactory);
        }
    }

    public static class Builder
    extends AbstractContentBuilder<Document, MongoDocument> {
        private AnnotationStoreFactory factory;

        public Builder(AnnotationStoreFactory annotationStoreFactory) {
            this.factory = annotationStoreFactory;
        }

        protected MongoDocument create(String id, String name, ImmutableProperties properties, Supplier<Document> data) {
            return new MongoDocument(id, name, this.factory, properties, data.get());
        }
    }
}

