/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.mongo;

import com.google.common.base.Strings;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.components.mongo.resources.Mongo;
import io.annot8.components.mongo.resources.MongoConnection;
import io.annot8.components.mongo.resources.MongoConnectionSettings;
import io.annot8.components.mongo.resources.MongoFactory;
import io.annot8.components.mongo.resources.MongoSettings;
import io.annot8.core.capabilities.UsesResource;
import io.annot8.core.capabilities.UsesResources;
import io.annot8.core.context.Context;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import io.annot8.core.settings.SettingsClass;
import io.annot8.core.settings.SettingsClasses;
import java.util.Optional;

@SettingsClasses(value={@SettingsClass(value=MongoSettings.class, optional=true), @SettingsClass(value=MongoConnectionSettings.class, optional=true)})
@UsesResources(value={@UsesResource(value=Mongo.class, optional=true), @UsesResource(value=MongoFactory.class, optional=true)})
public abstract class AbstractMongoComponent
extends AbstractComponent {
    private MongoConnection connection = null;

    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        Optional optionalMongoSettings = context.getSettings(MongoSettings.class);
        Optional optionalMongoConnectionSettings = context.getSettings(MongoConnectionSettings.class);
        if (optionalMongoSettings.isPresent() && !Strings.isNullOrEmpty((String)((MongoSettings)optionalMongoSettings.get()).getMongo())) {
            String key = ((MongoSettings)optionalMongoSettings.get()).getMongo();
            Optional optionalConnection = context.getResource(key, Mongo.class);
            if (!optionalConnection.isPresent()) {
                throw new MissingResourceException(String.format("Named Mongo {} is missing", key));
            }
            this.connection = (MongoConnection)optionalConnection.get();
        } else if (optionalMongoConnectionSettings.isPresent()) {
            Optional mongoFactory = context.getResource(MongoFactory.class);
            if (!mongoFactory.isPresent()) {
                throw new MissingResourceException("Missing MongoFactory needed for Mongo connection");
            }
            MongoConnectionSettings mergedSettings = ((MongoFactory)((Object)mongoFactory.get())).mergeWithDefaultSettings(optionalMongoConnectionSettings);
            Optional<MongoConnection> optionalConnection = ((MongoFactory)((Object)mongoFactory.get())).buildMongo(Optional.of(mergedSettings));
            if (!optionalConnection.isPresent()) {
                throw new BadConfigurationException("Unable to create Mongo connection from settings");
            }
            this.connection = optionalConnection.get();
        } else {
            Optional optionalMongo = context.getResource(Mongo.class);
            if (!optionalMongo.isPresent()) {
                throw new MissingResourceException("No Mongo resource available");
            }
            this.connection = (MongoConnection)optionalMongo.get();
        }
        if (this.connection == null) {
            this.log().error("Unable to create connection to Mongo");
            throw new BadConfigurationException("No Mongo connection");
        }
        this.configure(context, this.connection);
    }

    protected abstract void configure(Context var1, MongoConnection var2);

    public void close() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }
}

